namespace ProgramTests
{
  using System;
  using System.IO;
  using Xunit;
  using Exercise012;
  using TestMyCode.CSharp.API.Attributes;


  [Points("1-12")]
  public partial class ProgramTest
  {
    [Fact]
    public void TestGivenIntegerIsPrinted()
    {
      using (StringWriter sw = new StringWriter())
      {
        TextWriter stdout = Console.Out;
        Console.SetOut(sw);
        Console.SetOut(sw);

        var data = String.Join(Environment.NewLine, new[]
        {
                12
                });

        Console.SetIn(new System.IO.StringReader(data));

        Program.Main(null!);
        Console.SetOut(stdout);

        Assert.Contains("Give a number!\nYou gave 12\n", sw.ToString().Replace("\r\n", "\n"));
      }
    }

    [Fact]
    public void TestGivenDifferentIntegerIsPrinted()
    {
      using (StringWriter sw = new StringWriter())
      {
        TextWriter stdout = Console.Out;
        Console.SetOut(sw);
        Console.SetOut(sw);

        var data = String.Join(Environment.NewLine, new[]
        {
                47
                });

        Console.SetIn(new System.IO.StringReader(data));

        Program.Main(null!);
        Console.SetOut(stdout);

        Assert.Equal("Give a number!\nYou gave 47\n", sw.ToString().Replace("\r\n", "\n"));
      }
    }


    [Fact]
    public void TestGivenYetDifferentIntegerIsPrinted()
    {
      using (StringWriter sw = new StringWriter())
      {
        TextWriter stdout = Console.Out;
        Console.SetOut(sw);
        Console.SetOut(sw);

        var data = String.Join(Environment.NewLine, new[]
        {
                7779
                });

        Console.SetIn(new System.IO.StringReader(data));

        Program.Main(null!);
        Console.SetOut(stdout);

        Assert.Equal("Give a number!\nYou gave 7779\n", sw.ToString().Replace("\r\n", "\n"));
      }
    }

    [Fact]
    public void CheckNumberHasBeenConverted()
    {
      int counter = 0;
      Mono.Cecil.AssemblyDefinition assembly = Mono.Cecil.AssemblyDefinition.ReadAssembly(typeof(Program).Module.FullyQualifiedName);
      Mono.Cecil.TypeDefinition type = assembly.MainModule.GetType(typeof(Program).FullName);
      Mono.Cecil.MethodDefinition method = null;
      foreach (Mono.Cecil.MethodDefinition iter in type.Methods)
      {
        if (iter.Name == "Main")
        {
          method = iter;
        }
      }
      foreach (Mono.Cecil.Cil.Instruction instruction in method.Body.Instructions)
      {
        if (instruction.OpCode != Mono.Cecil.Cil.OpCodes.Call)
        {
          continue;
        }

        if (instruction.Operand is not Mono.Cecil.MethodReference methodReference)
        {
          continue;
        }
        if (methodReference.FullName == "System.Int32 System.Convert::ToInt32(System.String)" || methodReference.FullName == "System.Int32 System.Int32::Parse(System.String)")
        {
          counter++;
        }
      }
      Assert.Equal(1, counter);
    }
  }
}
