import unittest
from unittest.mock import patch

from tmc import points
from tmc.utils import load, load_module, reload_module, get_stdout, check_source
from functools import reduce
import os
import textwrap
from random import randint

exercise = 'src.sudoku_grid'
function = 'sudoku_grid_correct'

def p(sudoku):
    j = 0
    m = 'sudoku = [\n'
    for row in sudoku:
        s = ', '.join([str(i) for i in row])
        m += f'  [ {s} ],\n'
        j += 1
    return m +']' 

valids = [
  [
    [2, 6, 7, 8, 3, 9, 5, 0, 4],
    [9, 0, 3, 5, 1, 0, 6, 0, 0],
    [0, 5, 1, 6, 0, 0, 8, 3, 9],
    [5, 1, 9, 0, 4, 6, 3, 2, 8],
    [8, 0, 2, 1, 0, 5, 7, 0, 6],
    [6, 7, 4, 3, 2, 0, 0, 0, 5],
    [0, 0, 0, 4, 5, 7, 2, 6, 3],
    [3, 2, 0, 0, 8, 0, 0, 5, 7],
    [7, 4, 5, 0, 0, 3, 9, 0, 1],
  ],
  [
    [2, 9, 5, 0, 8, 4, 7, 1, 3],
    [6, 4, 8, 1, 3, 7, 9, 2, 5],
    [1, 7, 3, 2, 0, 9, 4, 6, 8],
    [8, 6, 0, 3, 4, 1, 2, 5, 7],
    [5, 2, 7, 8, 9, 6, 0, 3, 4],
    [3, 1, 4, 0, 7, 2, 6, 8, 9],
    [7, 5, 1, 9, 2, 8, 3, 4, 0],
    [4, 3, 6, 7, 1, 5, 8, 0, 2],
    [0, 8, 0, 4, 6, 3, 5, 7, 1],
  ],
  [
    [2, 6, 8, 1, 9, 3, 4, 7, 5],
    [3, 9, 1, 7, 0, 4, 2, 8, 6],
    [4, 5, 7, 8, 6, 2, 3, 1, 9],
    [9, 7, 4, 2, 8, 5, 6, 3, 1],
    [5, 8, 2, 3, 1, 6, 9, 4, 7],
    [6, 1, 3, 4, 0, 9, 0, 2, 8],
    [8, 3, 6, 9, 4, 1, 7, 0, 2],
    [1, 4, 9, 5, 2, 7, 8, 6, 3],
    [7, 2, 5, 0, 3, 8, 1, 9, 4],
  ],
  [
    [6, 7, 5, 3, 9, 2, 1, 0, 4],
    [2, 9, 3, 8, 4, 1, 6, 5, 0],
    [1, 4, 8, 5, 7, 0, 2, 3, 9],
    [8, 6, 7, 9, 2, 5, 3, 4, 1],
    [0, 2, 9, 4, 1, 3, 8, 7, 6],
    [3, 1, 4, 7, 6, 8, 5, 9, 0],
    [4, 8, 6, 2, 5, 7, 9, 1, 0],
    [7, 0, 2, 0, 3, 0, 4, 6, 0],
    [9, 3, 1, 6, 8, 4, 7, 2, 5],
  ],
  [
    [1, 3, 2, 8, 4, 5, 6, 9, 7],
    [7, 6, 9, 2, 3, 1, 4, 8, 5],
    [5, 4, 8, 9, 6, 7, 3, 2, 1],
    [8, 7, 4, 6, 1, 9, 5, 3, 2],
    [2, 5, 3, 4, 7, 8, 1, 6, 9],
    [9, 1, 6, 3, 5, 2, 7, 4, 8],
    [6, 2, 1, 5, 8, 3, 9, 7, 4],
    [4, 9, 7, 1, 2, 6, 8, 5, 3],
    [3, 8, 5, 7, 9, 4, 2, 1, 6],
  ],
  [
    [8, 3, 1, 5, 9, 4, 7, 2, 6],
    [6, 7, 2, 3, 8, 1, 5, 4, 9],
    [9, 5, 4, 7, 6, 2, 3, 1, 8],
    [2, 8, 3, 9, 1, 5, 6, 7, 4],
    [4, 6, 7, 8, 2, 3, 9, 5, 1],
    [1, 9, 5, 6, 4, 7, 8, 3, 2],
    [3, 1, 9, 4, 5, 6, 2, 8, 7],
    [7, 2, 8, 1, 3, 9, 4, 6, 5],
    [5, 4, 6, 2, 7, 8, 1, 9, 3],
  ],
  [
    [5, 0, 6, 4, 0, 7, 2, 1, 9],
    [2, 1, 9, 0, 6, 0, 7, 4, 0],
    [7, 4, 8, 0, 0, 2, 5, 3, 6],
    [1, 6, 5, 8, 0, 3, 4, 9, 2],
    [3, 8, 0, 0, 0, 4, 0, 0, 5],
    [4, 9, 2, 6, 5, 1, 3, 8, 7],
    [0, 0, 4, 5, 1, 0, 6, 7, 3],
    [0, 7, 3, 2, 0, 8, 9, 5, 1],
    [9, 0, 1, 0, 3, 6, 0, 2, 4],
  ],
  [
    [2, 5, 4, 0, 0, 0, 0, 1, 7],
    [8, 0, 0, 1, 7, 6, 4, 2, 0],
    [1, 0, 0, 0, 5, 4, 3, 0, 0],
    [5, 6, 2, 9, 0, 0, 1, 7, 3],
    [9, 0, 0, 7, 3, 0, 0, 5, 0],
    [7, 3, 0, 5, 6, 0, 0, 9, 4],
    [0, 2, 9, 3, 0, 0, 5, 6, 0],
    [0, 8, 7, 6, 0, 0, 0, 4, 2],
    [6, 1, 5, 4, 0, 9, 7, 3, 8],
  ],
  [
    [9, 3, 0, 0, 2, 6, 0, 0, 0],
    [0, 0, 5, 9, 1, 3, 0, 6, 2],
    [8, 6, 2, 7, 5, 4, 0, 3, 0],
    [0, 2, 0, 3, 0, 5, 6, 0, 0],
    [0, 5, 9, 0, 8, 0, 4, 0, 0],
    [6, 1, 0, 4, 7, 2, 3, 5, 0],
    [0, 9, 6, 0, 4, 8, 5, 7, 3],
    [2, 0, 4, 5, 0, 7, 0, 9, 0],
    [5, 7, 3, 0, 0, 9, 2, 8, 4],
  ],
  [
    [8, 7, 0, 0, 1, 6, 2, 5, 9],
    [1, 6, 0, 9, 2, 0, 8, 7, 4],
    [2, 5, 0, 0, 8, 7, 1, 0, 3],
    [4, 2, 7, 6, 0, 0, 9, 1, 0],
    [3, 0, 0, 5, 9, 1, 4, 2, 7],
    [9, 1, 5, 7, 0, 0, 0, 8, 0],
    [5, 3, 1, 2, 0, 0, 6, 0, 0],
    [6, 4, 8, 1, 5, 3, 0, 9, 0],
    [7, 0, 0, 8, 6, 0, 5, 3, 0],
  ],
  [
    [8, 3, 1, 7, 4, 9, 0, 6, 2],
    [9, 4, 7, 6, 2, 5, 0, 1, 3],
    [5, 2, 6, 1, 3, 8, 9, 7, 4],
    [4, 7, 8, 9, 6, 2, 3, 5, 1],
    [3, 1, 5, 8, 7, 4, 2, 9, 0],
    [2, 6, 9, 5, 1, 3, 4, 8, 7],
    [6, 9, 4, 2, 5, 1, 7, 0, 8],
    [7, 8, 3, 4, 9, 6, 1, 2, 5],
    [1, 0, 2, 3, 8, 7, 6, 0, 9],
  ],
  [
    [4, 8, 3, 7, 6, 2, 5, 1, 9],
    [6, 2, 7, 1, 9, 5, 8, 3, 4],
    [9, 5, 1, 3, 4, 8, 2, 7, 6],
    [3, 9, 5, 8, 7, 4, 6, 2, 1],
    [1, 6, 2, 5, 3, 9, 4, 8, 7],
    [7, 4, 8, 2, 1, 6, 9, 5, 3],
    [2, 7, 4, 6, 5, 1, 3, 9, 8],
    [8, 3, 9, 4, 2, 7, 1, 6, 5],
    [5, 1, 6, 9, 8, 3, 7, 4, 2],
  ],
  [
    [3, 4, 2, 7, 1, 6, 9, 5, 8],
    [1, 6, 7, 8, 5, 9, 4, 3, 2],
    [5, 9, 8, 2, 3, 4, 6, 1, 7],
    [4, 7, 3, 1, 6, 8, 2, 9, 5],
    [9, 2, 5, 3, 4, 7, 8, 6, 1],
    [6, 8, 1, 5, 9, 2, 7, 4, 3],
    [7, 1, 4, 6, 8, 5, 3, 2, 9],
    [8, 5, 6, 9, 2, 3, 1, 7, 4],
    [2, 3, 9, 4, 7, 1, 5, 8, 6],
  ],
  [
    [1, 6, 2, 7, 5, 3, 8, 9, 4],
    [8, 4, 9, 6, 2, 1, 3, 5, 7],
    [3, 7, 5, 4, 9, 8, 1, 2, 6],
    [6, 9, 8, 2, 1, 7, 4, 3, 5],
    [4, 5, 3, 9, 8, 6, 7, 1, 2],
    [7, 2, 1, 5, 3, 4, 6, 8, 9],
    [5, 1, 7, 3, 4, 9, 2, 6, 8],
    [2, 8, 6, 1, 7, 5, 9, 4, 3],
    [9, 3, 4, 8, 6, 2, 5, 7, 1],
  ],
  [
    [2, 0, 7, 0, 3, 5, 4, 8, 0],
    [9, 8, 0, 7, 2, 0, 0, 5, 0],
    [3, 5, 6, 0, 0, 8, 7, 1, 2],
    [0, 0, 0, 0, 0, 0, 3, 6, 0],
    [0, 7, 2, 3, 8, 6, 9, 4, 1],
    [8, 0, 3, 0, 1, 4, 0, 0, 5],
    [4, 0, 0, 1, 7, 0, 5, 0, 6],
    [7, 0, 1, 0, 6, 0, 8, 3, 4],
    [0, 2, 5, 8, 4, 0, 0, 9, 0],
  ],
  [
    [5, 1, 3, 9, 4, 8, 6, 7, 2],
    [2, 6, 7, 5, 0, 3, 4, 8, 9],
    [9, 4, 8, 0, 6, 7, 1, 3, 5],
    [1, 3, 2, 4, 8, 5, 7, 9, 6],
    [0, 8, 5, 6, 7, 9, 3, 0, 1],
    [6, 7, 9, 1, 3, 0, 8, 5, 4],
    [7, 9, 4, 3, 2, 6, 5, 1, 8],
    [8, 5, 1, 7, 9, 4, 2, 6, 3],
    [3, 2, 6, 8, 5, 1, 9, 0, 7],
  ],
  [
    [4, 7, 5, 8, 6, 2, 3, 9, 1],
    [2, 8, 6, 9, 1, 3, 4, 7, 5],
    [3, 9, 1, 7, 5, 4, 2, 8, 6],
    [1, 2, 8, 3, 9, 5, 6, 4, 7],
    [5, 3, 9, 4, 7, 6, 1, 2, 8],
    [6, 4, 7, 2, 8, 1, 5, 3, 9],
    [8, 6, 4, 1, 2, 9, 7, 5, 3],
    [7, 5, 3, 6, 4, 8, 9, 1, 2],
    [9, 1, 2, 5, 3, 7, 8, 6, 4],
  ],
  [
    [1, 0, 0, 0, 4, 9, 2, 7, 3],
    [4, 0, 9, 7, 2, 3, 1, 5, 8],
    [0, 0, 3, 5, 1, 8, 4, 6, 9],
    [0, 0, 0, 9, 7, 0, 5, 3, 0],
    [7, 9, 2, 3, 0, 1, 0, 0, 4],
    [5, 0, 0, 0, 6, 0, 7, 9, 2],
    [9, 4, 7, 2, 0, 0, 8, 1, 0],
    [0, 1, 6, 0, 9, 7, 3, 0, 0],
    [0, 2, 5, 1, 8, 0, 9, 0, 0],
  ],
  [
    [0, 2, 6, 3, 5, 7, 4, 1, 8],
    [0, 7, 5, 4, 1, 8, 9, 6, 2],
    [4, 8, 1, 0, 6, 2, 3, 5, 7],
    [7, 1, 0, 8, 4, 6, 0, 0, 5],
    [8, 6, 0, 2, 9, 5, 7, 3, 1],
    [2, 0, 9, 0, 0, 1, 0, 0, 6],
    [5, 3, 2, 1, 7, 4, 6, 8, 0],
    [0, 4, 7, 6, 8, 9, 5, 2, 3],
    [6, 9, 8, 5, 2, 3, 1, 0, 0],
  ],
  [
    [2, 6, 5, 8, 3, 1, 7, 9, 4],
    [3, 8, 1, 9, 4, 7, 5, 6, 2],
    [0, 9, 7, 6, 2, 5, 1, 8, 3],
    [9, 7, 3, 5, 6, 4, 2, 0, 8],
    [8, 1, 2, 7, 9, 3, 4, 5, 6],
    [6, 5, 4, 1, 8, 2, 3, 0, 9],
    [1, 2, 6, 3, 7, 8, 9, 4, 5],
    [5, 0, 9, 2, 1, 6, 8, 3, 7],
    [7, 3, 8, 4, 5, 9, 6, 2, 1],
  ],
  [
    [8, 0, 4, 0, 3, 0, 2, 5, 1],
    [2, 1, 0, 0, 8, 0, 3, 0, 9],
    [3, 9, 7, 5, 2, 0, 8, 4, 6],
    [0, 3, 6, 9, 7, 2, 0, 0, 0],
    [5, 8, 0, 0, 0, 3, 0, 9, 2],
    [0, 2, 9, 0, 0, 8, 4, 0, 3],
    [6, 0, 3, 2, 9, 5, 1, 8, 4],
    [9, 5, 2, 0, 1, 4, 6, 3, 7],
    [1, 4, 8, 3, 6, 0, 9, 0, 5],
  ],
  [
    [3, 0, 5, 0, 1, 0, 6, 0, 0],
    [9, 4, 1, 6, 8, 0, 2, 3, 5],
    [7, 6, 8, 2, 5, 0, 4, 9, 1],
    [4, 1, 0, 8, 9, 6, 5, 0, 7],
    [2, 5, 7, 1, 3, 4, 8, 6, 0],
    [6, 8, 0, 5, 7, 2, 0, 0, 3],
    [0, 7, 6, 3, 2, 1, 9, 8, 4],
    [0, 3, 2, 9, 4, 8, 7, 5, 6],
    [8, 9, 4, 7, 6, 0, 3, 1, 2],
  ],
  [
    [2, 0, 3, 0, 1, 0, 0, 4, 6],
    [4, 7, 0, 0, 2, 5, 9, 1, 8],
    [1, 9, 8, 0, 0, 7, 0, 2, 0],
    [3, 0, 0, 5, 0, 1, 4, 6, 9],
    [0, 0, 0, 9, 6, 0, 0, 0, 7],
    [6, 4, 9, 7, 0, 2, 0, 0, 5],
    [7, 0, 4, 0, 5, 8, 0, 9, 0],
    [0, 6, 1, 4, 7, 3, 8, 5, 2],
    [5, 8, 2, 1, 9, 6, 3, 0, 4],
  ],
  [
    [8, 1, 4, 9, 2, 6, 3, 0, 5],
    [7, 5, 3, 0, 1, 8, 9, 6, 2],
    [0, 0, 9, 0, 5, 7, 4, 0, 1],
    [0, 4, 0, 8, 0, 1, 6, 0, 3],
    [1, 9, 0, 0, 3, 2, 7, 5, 4],
    [2, 3, 6, 0, 4, 5, 0, 1, 0],
    [3, 7, 2, 5, 8, 4, 0, 9, 6],
    [4, 8, 5, 0, 6, 9, 0, 0, 0],
    [9, 6, 1, 2, 7, 3, 5, 4, 8],
  ],
  [
    [8, 0, 7, 4, 1, 5, 6, 9, 3],
    [3, 6, 9, 8, 7, 2, 5, 1, 4],
    [4, 5, 1, 3, 9, 6, 2, 7, 8],
    [7, 4, 2, 1, 5, 0, 8, 6, 0],
    [9, 8, 6, 7, 2, 4, 3, 5, 1],
    [1, 3, 5, 9, 6, 0, 4, 2, 7],
    [6, 7, 8, 2, 4, 1, 9, 3, 5],
    [2, 1, 4, 5, 3, 9, 7, 8, 6],
    [5, 9, 3, 6, 8, 7, 1, 0, 2],
  ],
  [
    [3, 4, 0, 5, 2, 6, 1, 0, 0],
    [5, 2, 0, 8, 1, 9, 0, 3, 0],
    [0, 0, 0, 0, 4, 7, 0, 5, 0],
    [0, 0, 3, 0, 0, 0, 0, 0, 0],
    [0, 9, 8, 0, 0, 3, 6, 4, 5],
    [0, 6, 5, 0, 9, 8, 7, 1, 3],
    [7, 0, 0, 0, 8, 2, 3, 0, 0],
    [9, 0, 0, 7, 5, 0, 8, 6, 0],
    [0, 8, 2, 9, 3, 1, 0, 0, 4],
  ],
  [
    [5, 0, 0, 7, 4, 0, 8, 9, 6],
    [0, 7, 1, 6, 8, 9, 5, 3, 2],
    [0, 6, 0, 2, 5, 3, 4, 1, 7],
    [6, 0, 8, 0, 2, 5, 0, 0, 9],
    [0, 9, 4, 0, 6, 0, 2, 5, 1],
    [2, 1, 5, 9, 0, 4, 6, 8, 3],
    [1, 0, 2, 0, 0, 7, 0, 6, 5],
    [9, 8, 7, 5, 0, 6, 1, 2, 0],
    [3, 0, 0, 4, 1, 0, 0, 7, 0],
  ],
  [
    [0, 0, 0, 0, 2, 8, 6, 9, 4],
    [0, 2, 3, 0, 4, 0, 0, 1, 5],
    [9, 0, 6, 7, 5, 1, 0, 8, 2],
    [0, 1, 4, 5, 0, 7, 2, 3, 9],
    [3, 9, 2, 4, 1, 6, 0, 7, 0],
    [7, 8, 5, 0, 9, 3, 0, 6, 1],
    [0, 3, 8, 9, 6, 2, 1, 4, 7],
    [2, 0, 9, 0, 7, 0, 8, 5, 3],
    [0, 0, 0, 8, 3, 0, 9, 2, 6],
  ],
  [
    [5, 3, 0, 4, 2, 7, 0, 6, 0],
    [4, 7, 2, 0, 6, 0, 5, 8, 0],
    [9, 0, 6, 0, 8, 3, 4, 2, 0],
    [2, 0, 7, 6, 1, 0, 0, 3, 4],
    [6, 5, 0, 8, 0, 0, 2, 0, 9],
    [0, 0, 3, 2, 7, 0, 6, 1, 0],
    [3, 2, 4, 7, 0, 6, 1, 0, 8],
    [1, 0, 5, 0, 0, 2, 7, 9, 6],
    [7, 6, 0, 0, 5, 8, 0, 0, 2],
  ],
  [
    [7, 9, 0, 0, 0, 8, 6, 1, 0],
    [1, 3, 6, 2, 0, 0, 4, 8, 5],
    [0, 5, 4, 6, 3, 1, 2, 7, 9],
    [0, 4, 8, 1, 6, 0, 0, 5, 2],
    [9, 6, 1, 0, 2, 5, 8, 0, 4],
    [5, 2, 7, 8, 0, 3, 1, 0, 6],
    [6, 8, 3, 9, 0, 2, 5, 4, 7],
    [4, 7, 5, 3, 8, 6, 9, 2, 1],
    [0, 1, 0, 5, 7, 4, 3, 6, 8],
  ],
]

invalids = [
  [
    [6, 4, 9, 2, 8, 3, 1, 5, 7],
    [0, 5, 0, 6, 4, 9, 2, 3, 8],
    [2, 3, 8, 1, 5, 7, 6, 4, 9],
    [9, 2, 3, 8, 1, 5, 0, 6, 4],
    [7, 6, 4, 9, 2, 3, 8, 1, 5],
    [8, 1, 5, 7, 0, 4, 9, 2, 0],
    [5, 7, 6, 4, 9, 2, 3, 2, 1],
    [4, 0, 2, 3, 8, 1, 5, 0, 6],
    [3, 0, 1, 5, 0, 6, 4, 9, 0],
  ],
  [
    [5, 4, 7, 9, 8, 0, 1, 6, 8],
    [2, 0, 3, 1, 8, 0, 7, 5, 7],
    [6, 1, 8, 0, 7, 5, 9, 2, 0],
    [4, 0, 5, 8, 2, 9, 7, 1, 0],
    [1, 0, 6, 3, 5, 9, 8, 9, 0],
    [9, 8, 0, 0, 6, 1, 9, 4, 5],
    [3, 2, 4, 6, 0, 8, 5, 7, 1],
    [8, 3, 0, 5, 1, 7, 2, 3, 0],
    [0, 5, 0, 0, 7, 0, 0, 8, 9],
  ],
  [
    [9, 6, 8, 0, 1, 0, 0, 3, 5],
    [2, 1, 0, 3, 5, 9, 0, 9, 0],
    [0, 5, 4, 9, 0, 0, 0, 0, 1],
    [4, 0, 6, 8, 9, 1, 5, 7, 2],
    [8, 9, 0, 7, 0, 5, 6, 0, 3],
    [7, 2, 0, 0, 3, 1, 0, 8, 0],
    [1, 0, 2, 0, 7, 9, 3, 0, 0],
    [6, 4, 9, 1, 2, 0, 3, 5, 7],
    [0, 7, 0, 4, 6, 4, 2, 3, 8],
  ],
  [
    [6, 0, 2, 3, 8, 9, 1, 5, 4],
    [9, 7, 8, 1, 4, 0, 7, 6, 2],
    [5, 1, 5, 7, 2, 6, 3, 9, 8],
    [7, 7, 6, 4, 9, 3, 2, 1, 5],
    [3, 4, 9, 2, 5, 1, 8, 7, 6],
    [1, 2, 5, 8, 6, 7, 4, 3, 9],
    [4, 5, 3, 6, 1, 2, 9, 8, 4],
    [2, 0, 1, 9, 0, 8, 5, 4, 3],
    [8, 9, 7, 5, 3, 4, 6, 2, 1],
  ],
  [
    [4, 0, 0, 0, 0, 9, 3, 1, 0],
    [0, 6, 0, 4, 0, 4, 0, 0, 9],
    [9, 0, 6, 0, 0, 8, 5, 2, 0],
    [0, 3, 9, 0, 8, 2, 1, 0, 0],
    [0, 7, 0, 3, 9, 8, 7, 0, 2],
    [0, 0, 8, 7, 4, 1, 9, 3, 0],
    [0, 0, 6, 4, 2, 7, 1, 9, 3],
    [7, 4, 0, 9, 1, 3, 6, 8, 5],
    [0, 0, 1, 0, 0, 0, 2, 4, 0],
  ],
  [
    [0, 0, 3, 2, 2, 1, 4, 6, 5],
    [9, 2, 1, 4, 5, 3, 8, 3, 7],
    [5, 0, 6, 8, 7, 3, 0, 1, 9],
    [6, 2, 4, 9, 3, 0, 5, 0, 9],
    [3, 9, 8, 5, 1, 2, 2, 4, 6],
    [1, 5, 5, 7, 6, 4, 9, 8, 3],
    [2, 6, 5, 3, 4, 7, 1, 0, 6],
    [4, 3, 7, 1, 0, 0, 6, 5, 0],
    [1, 8, 9, 6, 2, 5, 3, 0, 4],
  ],
  [
    [0, 0, 2, 0, 0, 0, 5, 1, 0],
    [4, 7, 8, 0, 6, 0, 0, 3, 0],
    [0, 0, 0, 0, 0, 9, 7, 4, 8],
    [9, 3, 0, 0, 3, 8, 6, 0, 0],
    [7, 0, 3, 5, 4, 0, 2, 9, 1],
    [5, 6, 0, 9, 0, 0, 3, 7, 3],
    [8, 0, 9, 6, 0, 4, 0, 0, 5],
    [0, 4, 0, 2, 5, 0, 3, 8, 0],
    [0, 1, 0, 8, 0, 0, 4, 5, 7],
  ],
  [
    [2, 4, 9, 3, 1, 5, 6, 7, 8],
    [1, 5, 3, 1, 7, 6, 4, 2, 9],
    [7, 6, 8, 9, 2, 4, 5, 1, 3],
    [4, 3, 2, 1, 5, 8, 9, 6, 7],
    [5, 8, 1, 7, 6, 9, 3, 4, 2],
    [6, 7, 9, 2, 4, 3, 8, 5, 1],
    [9, 6, 2, 4, 3, 1, 7, 8, 5],
    [3, 1, 4, 5, 8, 7, 2, 9, 6],
    [8, 7, 5, 6, 9, 2, 1, 3, 4],
  ],
  [
    [8, 5, 7, 4, 9, 3, 2, 3, 6],
    [3, 6, 2, 3, 5, 8, 4, 6, 1],
    [9, 1, 4, 2, 3, 6, 7, 8, 5],
    [7, 4, 6, 0, 4, 8, 1, 2, 9],
    [2, 9, 1, 6, 3, 7, 5, 4, 8],
    [4, 8, 5, 1, 2, 9, 0, 0, 3],
    [2, 2, 9, 3, 0, 7, 8, 1, 4],
    [1, 4, 8, 9, 6, 1, 3, 5, 7],
    [5, 7, 3, 8, 1, 4, 9, 6, 8],
  ],
  [
    [9, 5, 8, 3, 2, 6, 8, 7, 4],
    [7, 4, 1, 8, 5, 9, 3, 6, 2],
    [6, 2, 3, 1, 4, 7, 8, 9, 5],
    [4, 1, 6, 7, 8, 5, 9, 2, 3],
    [2, 9, 3, 6, 1, 4, 7, 5, 8],
    [5, 8, 9, 7, 3, 2, 6, 4, 1],
    [3, 9, 5, 2, 6, 1, 4, 8, 7],
    [1, 6, 2, 4, 7, 8, 5, 3, 9],
    [8, 7, 4, 5, 9, 3, 2, 1, 6],
  ],
  [
    [7, 0, 1, 0, 8, 9, 2, 0, 0],
    [0, 6, 4, 7, 3, 1, 5, 8, 3],
    [0, 8, 0, 0, 6, 7, 4, 0, 0],
    [3, 9, 7, 0, 4, 0, 5, 1, 6],
    [8, 8, 5, 6, 0, 2, 3, 0, 0],
    [6, 1, 7, 3, 9, 7, 8, 4, 0],
    [0, 5, 3, 4, 2, 8, 1, 7, 6],
    [1, 7, 0, 9, 0, 3, 0, 2, 0],
    [4, 2, 8, 0, 0, 6, 9, 0, 5],
  ],
  [
    [6, 5, 1, 3, 0, 3, 9, 8, 0],
    [4, 5, 8, 6, 1, 1, 0, 0, 7],
    [0, 0, 2, 0, 8, 9, 5, 1, 0],
    [2, 0, 0, 8, 3, 7, 0, 9, 1],
    [8, 7, 3, 0, 9, 0, 6, 5, 2],
    [1, 0, 0, 2, 6, 5, 7, 0, 0],
    [0, 8, 0, 0, 4, 1, 0, 6, 0],
    [0, 1, 0, 0, 6, 2, 0, 7, 9],
    [0, 0, 4, 0, 7, 8, 1, 4, 5],
  ],
  [
    [0, 6, 7, 4, 0, 8, 4, 9, 1],
    [9, 4, 1, 8, 7, 6, 8, 3, 0],
    [3, 8, 5, 9, 1, 4, 6, 2, 7],
    [4, 1, 6, 0, 9, 7, 5, 8, 2],
    [6, 7, 9, 8, 2, 5, 0, 4, 3],
    [8, 5, 0, 4, 0, 0, 7, 6, 9],
    [1, 0, 8, 7, 4, 9, 2, 5, 6],
    [5, 2, 6, 1, 8, 3, 9, 7, 4],
    [7, 9, 4, 5, 0, 2, 3, 1, 8],
  ],
  [
    [7, 7, 9, 1, 8, 5, 2, 4, 6],
    [1, 5, 8, 6, 2, 4, 9, 7, 3],
    [6, 4, 2, 3, 9, 7, 8, 5, 1],
    [1, 9, 6, 3, 5, 8, 1, 2, 4],
    [4, 2, 1, 9, 6, 9, 3, 8, 5],
    [5, 8, 3, 4, 1, 2, 6, 9, 7],
    [8, 3, 7, 2, 1, 5, 4, 6, 9],
    [9, 6, 4, 8, 7, 3, 5, 1, 2],
    [4, 1, 5, 9, 4, 6, 7, 3, 8],
  ],
  [
    [3, 1, 0, 2, 0, 0, 9, 8, 6],
    [9, 6, 8, 1, 4, 5, 3, 4, 0],
    [3, 2, 4, 0, 0, 9, 5, 7, 1],
    [4, 3, 1, 9, 2, 8, 7, 5, 6],
    [8, 9, 2, 5, 6, 7, 4, 1, 3],
    [7, 5, 6, 0, 1, 4, 8, 2, 9],
    [6, 7, 0, 4, 5, 1, 0, 3, 8],
    [1, 4, 0, 8, 3, 2, 6, 9, 0],
    [2, 8, 0, 7, 9, 6, 1, 0, 0],
  ],
  [
    [2, 0, 1, 9, 8, 0, 4, 0, 3],
    [8, 0, 0, 6, 3, 0, 0, 0, 0],
    [6, 4, 3, 0, 0, 0, 5, 9, 8],
    [3, 1, 6, 7, 5, 0, 0, 4, 0],
    [8, 4, 9, 3, 1, 6, 0, 7, 0],
    [0, 0, 0, 8, 4, 9, 0, 3, 0],
    [1, 0, 3, 0, 0, 0, 0, 4, 6],
    [5, 9, 7, 4, 0, 0, 3, 1, 2],
    [4, 6, 8, 1, 2, 0, 7, 0, 0],
  ],
  [
    [3, 7, 3, 9, 8, 2, 1, 4, 5],
    [0, 0, 8, 1, 4, 5, 7, 7, 6],
    [4, 1, 8, 0, 3, 6, 9, 8, 2],
    [2, 8, 1, 4, 5, 7, 3, 6, 9],
    [0, 4, 7, 0, 6, 9, 8, 2, 1],
    [6, 3, 0, 8, 2, 1, 4, 5, 0],
    [0, 6, 8, 2, 1, 4, 5, 7, 3],
    [7, 5, 3, 6, 5, 0, 2, 1, 4],
    [0, 2, 0, 5, 7, 3, 6, 9, 8],
  ],
  [
    [7, 8, 5, 9, 0, 2, 6, 1, 4],
    [0, 0, 3, 0, 6, 4, 5, 7, 8],
    [1, 4, 6, 7, 5, 8, 3, 9, 2],
    [7, 3, 0, 6, 4, 0, 0, 5, 0],
    [6, 0, 0, 5, 8, 1, 0, 3, 0],
    [0, 1, 8, 0, 2, 0, 4, 6, 0],
    [8, 0, 8, 2, 3, 5, 9, 4, 3],
    [4, 3, 9, 8, 1, 0, 0, 2, 5],
    [2, 0, 0, 4, 0, 3, 1, 8, 6],
  ],
  [
    [3, 0, 6, 8, 4, 7, 5, 9, 2],
    [0, 4, 7, 9, 2, 5, 1, 0, 3],
    [9, 0, 0, 0, 6, 0, 8, 7, 4],
    [1, 8, 9, 7, 9, 2, 6, 5, 3],
    [5, 3, 0, 8, 0, 4, 2, 7, 9],
    [7, 8, 0, 5, 3, 6, 2, 5, 0],
    [4, 7, 9, 0, 5, 3, 8, 6, 1],
    [6, 0, 4, 8, 7, 9, 3, 2, 0],
    [2, 5, 0, 6, 1, 8, 4, 9, 7],
  ],
  [
    [4, 8, 1, 2, 0, 9, 7, 0, 3],
    [7, 0, 3, 1, 0, 8, 6, 9, 2],
    [6, 9, 2, 3, 7, 5, 4, 8, 1],
    [5, 3, 4, 0, 8, 1, 9, 2, 7],
    [0, 0, 8, 7, 9, 2, 5, 3, 4],
    [9, 2, 7, 4, 5, 0, 8, 1, 0],
    [2, 7, 5, 8, 4, 4, 1, 6, 0],
    [1, 6, 9, 5, 2, 7, 3, 4, 8],
    [0, 4, 0, 9, 1, 6, 2, 7, 5],
  ],
  [
    [2, 6, 7, 8, 3, 9, 5, 0, 4],
    [9, 0, 3, 5, 1, 0, 6, 0, 0],
    [0, 5, 6, 0, 0, 0, 8, 3, 9],
    [5, 1, 9, 0, 4, 6, 3, 2, 8],
    [8, 0, 2, 1, 0, 5, 7, 0, 6],
    [6, 7, 4, 3, 2, 0, 0, 0, 5],
    [0, 0, 0, 4, 5, 7, 2, 6, 3],
    [3, 2, 0, 0, 8, 0, 0, 5, 7],
    [7, 4, 5, 0, 0, 3, 9, 0, 1],
  ],
  [
    [2, 9, 5, 0, 8, 4, 7, 1, 3],
    [6, 4, 8, 1, 3, 7, 9, 2, 5],
    [1, 7, 3, 2, 0, 9, 4, 6, 8],
    [8, 6, 0, 3, 4, 1, 2, 5, 7],
    [5, 2, 7, 8, 9, 6, 0, 3, 4],
    [3, 1, 4, 0, 7, 2, 6, 8, 9],
    [7, 5, 0, 9, 2, 8, 1, 4, 0],
    [4, 3, 6, 7, 1, 5, 8, 0, 2],
    [0, 8, 0, 4, 6, 3, 5, 7, 1],
  ],
  [
    [2, 6, 8, 1, 9, 3, 4, 7, 5],
    [3, 9, 1, 7, 0, 4, 2, 8, 6],
    [4, 5, 7, 8, 6, 2, 3, 1, 9],
    [9, 7, 4, 2, 8, 5, 6, 3, 1],
    [5, 8, 0, 3, 2, 6, 9, 4, 7],
    [6, 1, 3, 4, 0, 9, 0, 2, 8],
    [8, 3, 6, 9, 4, 1, 7, 0, 2],
    [1, 4, 9, 5, 0, 7, 8, 6, 3],
    [7, 2, 5, 0, 3, 8, 1, 9, 4],
  ],
]

@points('5.sudoku_grid')
class SudokuTest(unittest.TestCase):
    @classmethod
    def setUpClass(cls):
        with patch('builtins.input', side_effect=[AssertionError("Asking input from the user was not expected")]):
           cls.module = load_module(exercise, 'en')

    def test_0_main_program_ok(self):
        ok, line = check_source(self.module)
        message =  """The code for testing the functions should be placed inside
if __name__ == "__main__":
block. The following row should be moved:
"""
        self.assertTrue(ok, message+line)

    def test_1_function_exists(self):
        try:
            from src.sudoku_grid import sudoku_grid_correct
        except:
            self.assertTrue(False, f'Your code should contain function named as sudoku_grid_correct(sudoku: list)')
        try:
            sudoku_grid_correct = load(exercise, function, 'en')
            s = sudoku = [
                [ 9, 0, 0, 0, 8, 0, 3, 0, 0 ],
                [ 2, 0, 0, 2, 5, 0, 7, 0, 0 ],
                [ 0, 2, 0, 3, 0, 0, 0, 0, 4 ],
                [ 2, 9, 4, 0, 0, 0, 0, 0, 0 ],
                [ 0, 0, 0, 7, 3, 0, 5, 6, 0 ],
                [ 7, 0, 5, 0, 6, 0, 4, 0, 0 ],
                [ 0, 0, 7, 8, 0, 3, 9, 0, 0 ],
                [ 0, 0, 1, 0, 0, 0, 0, 0, 3 ],
                [ 3, 0, 0, 0, 0, 0, 0, 0, 2 ],
            ]
            ps = p(s)
            sudoku_grid_correct(s)
        except:
            self.assertTrue(False, f'Make sure, that function can be called as follows\n{ps}\nsudoku_grid_correct(sudoku)')

    def test_2_type_of_return_value(self):
        sudoku_grid_correct = load(exercise, function, 'en')
        s = sudoku = [
            [ 9, 0, 0, 0, 8, 0, 3, 0, 0 ],
            [ 2, 0, 0, 2, 5, 0, 7, 0, 0 ],
            [ 0, 2, 0, 3, 0, 0, 0, 0, 4 ],
            [ 2, 9, 4, 0, 0, 0, 0, 0, 0 ],
            [ 0, 0, 0, 7, 3, 0, 5, 6, 0 ],
            [ 7, 0, 5, 0, 6, 0, 4, 0, 0 ],
            [ 0, 0, 7, 8, 0, 3, 9, 0, 0 ],
            [ 0, 0, 1, 0, 0, 0, 0, 0, 3 ],
            [ 3, 0, 0, 0, 0, 0, 0, 0, 2 ],
        ]
        ps = p(s)
        val = sudoku_grid_correct(s)
        self.assertTrue(type(val) == bool, f"Function {function} does not return boolean value when calling\n{ps}\nsudoku_grid_correct(sudoku)")

    def test_3_functinality_with_invalids(self):
        sudoku_grid_correct = load(exercise, function, 'en')
        for s in invalids:
            ps = p(s)
            try:
              val = sudoku_grid_correct(s)
            except:
              self.assertEqual(val, False, f"Make sure, that the function can be called as follows\n{ps}\nsudoku_grid_correct(sudoku)")
            self.assertEqual(val, False, f"The result {val} is incorrect when calling \n{ps}\nsudoku_grid_correct(sudoku)")

    def test_4_functionality_with_valids(self):
        sudoku_grid_correct = load(exercise, function, 'en')
        for s in valids:
            ps = p(s)
            try:
              val = sudoku_grid_correct(s)
            except:
              self.assertTrue(False, f"Varmista että seuraava kutsu toimii\n{ps}\nsudoku_grid_correct(sudoku)")
            self.assertEqual(val, True, f"The result {val} is incorrect when calling \n{ps}\nsudoku_grid_correct(sudoku)")

if __name__ == '__main__':
    unittest.main()
