namespace ProgramTests
{
    using Xunit;
    using Exercise004;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("2-4.1")]
        public void TestExample()
        {
            Revolutions r = new Revolutions();
            Assert.Equal(3, r.Calculate(new int[] { 4, 1, 3, 2, 5 }));
            Assert.Equal(1, r.Calculate(new int[] { 1, 2, 3, 4, 5 }));
            Assert.Equal(5, r.Calculate(new int[] { 5, 4, 3, 2, 1 }));
            Assert.Equal(4, r.Calculate(new int[] { 4, 3, 2, 1 }));
        }

        [Fact]
        [Points("2-4.1")]
        public void TestSingleArray()
        {
            Revolutions r = new Revolutions();
            Assert.Equal(1, r.Calculate(new int[] { 1 }));
        }

        [Fact]
        [Points("2-4.1")]
        public void TestAlternatingArray()
        {
            Revolutions r = new Revolutions();
            Assert.Equal(2, r.Calculate(new int[] { 4, 1, 5, 2, 6, 3 }));
        }

        [Fact]
        [Points("2-4.2")]
        public void TestLargeAlternatingArray()
        {
            Revolutions r = new Revolutions();
            Assert.Equal(4, r.Calculate(new int[] { 6, 4, 7, 1, 8, 3, 9, 2, 10, 5, 11 }));
        }

        [Fact]
        [Points("2-4.2")]
        public void TestSingleLargeArray()
        {
            Revolutions r = new Revolutions();
            Assert.Equal(9, r.Calculate(new int[] { 4, 1, 3, 2, 5, 12, 18, 14, 17, 15, 16, 13, 11, 10, 6, 7, 8, 9 }));
        }

        [Fact]
        [Points("2-4.2")]
        public void TestLargerArrays()
        {
            Revolutions r = new Revolutions();
            Assert.Equal(6, r.Calculate(new int[] { 4, 1, 3, 2, 5, 7, 6, 8, 9, 10, 11, 14, 13, 12 }));
            Assert.Equal(1, r.Calculate(new int[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 }));
            Assert.Equal(10, r.Calculate(new int[] { 10, 9, 8, 7, 6, 5, 4, 3, 2, 1 }));
        }
    }
}
