namespace ProgramTests
{
    using Xunit;
    using Exercise002;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("2-2.1")]
        public void ExampleWorks()
        {
            LongestRepetition p = new LongestRepetition();
            Assert.Equal(2, p.Calculate(new int[] { 1, 2, 1, 1, 2 }));
            Assert.Equal(1, p.Calculate(new int[] { 1, 2, 3, 4, 5 }));
            Assert.Equal(5, p.Calculate(new int[] { 1, 1, 1, 1, 1 }));
            Assert.Equal(1, p.Calculate(new int[] { 12 }));
        }

        [Fact]
        [Points("2-2.1")]
        public void SingleArraysWork()
        {
            LongestRepetition p = new LongestRepetition();
            Assert.Equal(1, p.Calculate(new int[] { 1 }));
            Assert.Equal(1, p.Calculate(new int[] { 3 }));
            Assert.Equal(1, p.Calculate(new int[] { 79 }));
        }

        [Fact]
        [Points("2-2.1")]
        public void ArrayWithConcurrentRepetitionWorksWithouTimeout()
        {
            LongestRepetition p = new LongestRepetition();
            int[] arr = new int[] { 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2 };
            Assert.Equal(3, p.Calculate(arr));
        }

        [Fact]
        [Points("2-2.2")]
        public void LargeNumbersWork()
        {
            LongestRepetition p = new LongestRepetition();
            Assert.Equal(4, p.Calculate(new int[] { 2341, 2341, 2341, 129445, 129445, 129445, 129445, 2341 }));
            Assert.Equal(4, p.Calculate(new int[] { 2341, 2341, 2341, 129445, 129445, 129445, 129445, 2341, 2341, 2341, 2341, 129445, 129445, 129445, 129445, 2341, 2341, 2341, 2341, 129445, 129445, 129445, 129445, 2341, 2341, 2341, 5 }));
            Assert.Equal(1, p.Calculate(new int[] { 666999666 }));
        }

        [Fact]
        [Points("2-2.2")]
        public void ArrayWithLargerRepetitionWorks()
        {
            LongestRepetition p = new LongestRepetition();
            int[] arr = new int[] { 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3 };
            Assert.Equal(9, p.Calculate(arr));
        }

        [Fact]
        [Points("2-2.2")]
        public void LargeArrayWithOneWorksWithoutTimeout()
        {
            LongestRepetition p = new LongestRepetition();
            int[] arr = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 14, 18, 17, 16, 19, 20 };
            Assert.Equal(1, p.Calculate(arr));
        }
    }
}
