namespace ProgramTests
{
    using Xunit;
    using Exercise005;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("2-5.1")]
        public void TestZeroExamples()
        {
            Split s = new Split();
            Assert.Equal(0, s.Calculate(new int[] { 1, 2, 3, 4, 5 }));
            Assert.Equal(0, s.Calculate(new int[] { 1, 7, 4, 2, 2, 5, 6 }));
        }

        [Fact]
        [Points("2-5.1")]
        public void TestOtherExamples()
        {
            Split s = new Split();
            Assert.Equal(1, s.Calculate(new int[] { 1, 2, -1, 4, 0 }));
            Assert.Equal(4, s.Calculate(new int[] { 0, 0, 0, 0, 0 }));
        }

        [Fact]
        [Points("2-5.1")]
        public void TestSlightlyChanged()
        {
            Split s = new Split();
            Assert.Equal(1, s.Calculate(new int[] { 1, -2, -1, 4, 0 }));
            Assert.Equal(0, s.Calculate(new int[] { 0, 0, 1, 0, 0 }));
        }

        [Fact]
        [Points("2-5.2")]
        public void TestSlightlyLarger()
        {
            Split s = new Split();
            Assert.Equal(7, s.Calculate(new int[] { 1, -2, -1, 4, 0, 0, 0, 0, 0, 0, 2 }));
            Assert.Equal(7, s.Calculate(new int[] { 0, 0, 1, 0, 0, 2, 0, 0, 0, 0, 0, 0, 3 }));
        }

        [Fact]
        [Points("2-5.2")]
        public void TestPlentyZeros()
        {
            Split s = new Split();
            Assert.Equal(13, s.Calculate(new int[] { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 }));
        }

        [Fact]
        [Points("2-5.2")]
        public void TestLargerNumbers()
        {
            Split s = new Split();
            Assert.Equal(1, s.Calculate(new int[] { 42, 39, 137, 2, 2, 2, 222, 2 }));
        }
    }
}
