namespace ProgramTests
{
    using System;
    using Xunit;
    using Exercise001;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {

        [Fact]
        [Points("2-1.1")]
        public void AnswersAreAlike()
        {
            Inefficient inefficient = new Inefficient();
            Efficient efficient = new Efficient();
            string input = "0101011001101010010";
            Assert.Equal(41, inefficient.Counter(input));
            Assert.Equal(41, efficient.Counter(input));
        }

        [Fact]
        [Points("2-1.1")]
        public void AnswersAreAlikeWithLargerExample()
        {
            Inefficient inefficient = new Inefficient();
            Efficient efficient = new Efficient();
            string input = "0101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110";
            Assert.Equal(10947280, inefficient.Counter(input));
            Assert.Equal(10947280, efficient.Counter(input));
        }

        [Fact]
        [Points("2-1.1")]
        public void InefficientWorksAsIntended()
        {
            Inefficient inefficient = new Inefficient();
            string input = "010101";
            Assert.Equal(6, inefficient.Counter(input));
        }

        [Fact]
        [Points("2-1.2")]
        public void EfficientWorksAsIntended()
        {
            Efficient efficient = new Efficient();
            string input = "010101";
            Assert.Equal(6, efficient.Counter(input));
        }

        [Fact]
        [Points("2-1.2")]
        public void BothMethodsWork()
        {
            Inefficient inefficient = new Inefficient();
            Efficient efficient = new Efficient();
            string input = "0101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010101010101100101001010001010101101010100010101010110101010010110101010101110101010100101010101101100100101011001101010";
            Assert.Equal(10834304, inefficient.Counter(input));
            Assert.Equal(10834304, efficient.Counter(input));
        }

        [Fact]
        [Points("2-1.2")]
        public void EfficientIsMoreEfficientThanInefficient()
        {
            Inefficient inefficient = new Inefficient();
            Efficient efficient = new Efficient();
            // Same input for both, so output should be same
            string input = "010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011010101001011010101010111010101010010101010110110010010101100110101010101010110010100101000101010110101010001010101011";

            // Timing for inefficient
            DateTime startInefficient = DateTime.Now;
            inefficient.Counter(input);
            DateTime endInefficient = DateTime.Now;
            TimeSpan diffInefficient = endInefficient.Subtract(startInefficient);

            // Timing for efficient
            DateTime startEfficient = DateTime.Now;
            efficient.Counter(input);
            DateTime endEfficient = DateTime.Now;
            TimeSpan diffEfficient = endEfficient.Subtract(startEfficient);

            Assert.True(diffInefficient > diffEfficient);
        }
    }
}
