namespace ProgramTests
{
    using Xunit;
    using Exercise003;
    using TestMyCode.CSharp.API.Attributes;

    public partial class ProgramTest
    {
        [Fact]
        [Points("2-3.1")]
        public void TestSomeOfTheExample()
        {
            Changes m = new Changes();
            Assert.Equal(2, m.Calculate(new int[] { 1, 1, 2, 2, 2 }));
            Assert.Equal(0, m.Calculate(new int[] { 1, 2, 3, 4, 5 }));
            Assert.Equal(4, m.Calculate(new int[] { 1, 1, 1, 1, 1, 1, 1, 1, 1 }));
        }

        [Fact]
        [Points("2-3.1")]
        public void TestRestOfTheExample()
        {
            Changes m = new Changes();
            Assert.Equal(2, m.Calculate(new int[] { 0, 0, 0, 0, 0 }));
            Assert.Equal(2, m.Calculate(new int[] { 1, 1, 1, 1 }));
            Assert.Equal(2, m.Calculate(new int[] { 0, 0, 0, 0 }));
            Assert.Equal(1, m.Calculate(new int[] { 0, 0, 0 }));
        }

        [Fact]
        [Points("2-3.2")]
        public void TestBiggerValues()
        {
            Changes m = new Changes();
            Assert.Equal(5, m.Calculate(new int[] { 6667, 6667, 6667, 6667, 6667, 6667, 6667, 6667, 6667, 6667 }));
        }

        [Fact]
        [Points("2-3.2")]
        public void TestLargerArray()
        {
            Changes m = new Changes();
            Assert.Equal(10, m.Calculate(new int[] { 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 }));
        }
    }
}
