namespace ProgramTests
{
    using System.Collections.Generic;
    using Xunit;
    using Exercise004;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("6-4.1")]
        public void TestFirstExample()
        {
            ShortestPath s = new ShortestPath(5);
            s.AddRoad(1, 2, 7);
            s.AddRoad(2, 4, 2);
            s.AddRoad(1, 3, 6);
            s.AddRoad(3, 4, 5);
            s.AddRoad(4, 5, 3);
            Assert.Equal(new List<int> { 1, 2, 4, 5 }, s.Create(1, 5));
        }

        [Fact]
        [Points("6-4.1")]
        public void TestSingleNodeReturnsItself()
        {
            ShortestPath s = new ShortestPath(3);
            s.AddRoad(3, 3, 3);
            Assert.Equal(new List<int> { 3 }, s.Create(3, 3));
        }

        [Fact]
        [Points("6-4.1")]
        public void TestSmallGraphShorterFromRoundTrip()
        {
            ShortestPath s = new ShortestPath(3);
            s.AddRoad(1, 2, 5);
            s.AddRoad(1, 3, 1);
            s.AddRoad(2, 3, 1);
            Assert.Equal(new List<int> { 2, 3, 1 }, s.Create(2, 1));
        }

        [Fact]
        [Points("6-4.2")]
        public void TestSecondExample()
        {
            ShortestPath s = new ShortestPath(5);
            s.AddRoad(1, 2, 7);
            s.AddRoad(2, 4, 2);
            s.AddRoad(1, 3, 6);
            s.AddRoad(3, 4, 5);
            s.AddRoad(4, 5, 3);
            Assert.Equal(new List<int> { 1, 2 }, s.Create(1, 2));
        }

        [Fact]
        [Points("6-4.2")]
        public void TestConnections()
        {
            ShortestPath s = new ShortestPath(5);
            s.AddRoad(1, 2, 7);
            s.AddRoad(1, 3, 6);
            s.AddRoad(3, 4, 5);
            s.AddRoad(4, 5, 3);
            Assert.Equal(new List<int> { 1, 3, 4, 5 }, s.Create(1, 5));
        }

        [Fact]
        [Points("6-4.2")]
        public void TestLargerGraphWithShorterTrip()
        {
            ShortestPath s = new ShortestPath(12);
            s.AddRoad(12, 1, 42);
            s.AddRoad(1, 3, 6);
            s.AddRoad(3, 6, 8);
            s.AddRoad(6, 12, 4);
            Assert.Equal(new List<int> { 12, 6, 3, 1 }, s.Create(12, 1));
        }

        [Fact]
        [Points("6-4.3")]
        public void TestThirdExample()
        {
            ShortestPath s = new ShortestPath(5);
            s.AddRoad(1, 2, 7);
            s.AddRoad(2, 4, 2);
            s.AddRoad(1, 3, 6);
            s.AddRoad(3, 4, 5);
            s.AddRoad(4, 5, 3);
            Assert.Equal(new List<int> { 1, 2, 4 }, s.Create(1, 4));
        }

        [Fact]
        [Points("6-4.3")]
        public void TestLargerGraph()
        {
            ShortestPath s = new ShortestPath(12);
            s.AddRoad(1, 2, 7);
            s.AddRoad(2, 3, 2);
            s.AddRoad(4, 5, 6);
            s.AddRoad(5, 3, 5);
            s.AddRoad(6, 1, 3);
            s.AddRoad(6, 8, 7);
            s.AddRoad(8, 7, 2);
            s.AddRoad(12, 7, 6);
            s.AddRoad(12, 11, 5);
            s.AddRoad(10, 1, 3);
            s.AddRoad(9, 10, 7);
            Assert.Equal(new List<int> { 1, 6, 8, 7, 12 }, s.Create(1, 12));
        }

        [Fact]
        [Points("6-4.3")]
        public void TestYetAnotherGraph()
        {
            ShortestPath s = new ShortestPath(9);
            s.AddRoad(1, 2, 7);
            s.AddRoad(2, 3, 7);
            s.AddRoad(3, 4, 7);
            s.AddRoad(4, 5, 7);
            s.AddRoad(5, 6, 7);
            s.AddRoad(6, 7, 7);
            s.AddRoad(7, 8, 7);
            s.AddRoad(5, 2, 7);
            s.AddRoad(1, 9, 17);
            Assert.Equal(new List<int> { 9, 1 }, s.Create(9, 1));
        }

        [Fact]
        [Points("6-4.4")]
        public void TestFourthExample()
        {
            ShortestPath s = new ShortestPath(5);
            s.AddRoad(1, 2, 7);
            s.AddRoad(2, 4, 2);
            s.AddRoad(1, 3, 6);
            s.AddRoad(3, 4, 5);
            s.AddRoad(4, 5, 3);
            Assert.Equal(new List<int> { 4, 2, 1 }, s.Create(4, 1));
        }

        [Fact]
        [Points("6-4.4")]
        public void TestShortestPathsInLargerGraph()
        {
            ShortestPath s = new ShortestPath(12);
            s.AddRoad(12, 1, 27);
            s.AddRoad(1, 3, 2);
            s.AddRoad(3, 2, 6);
            s.AddRoad(2, 1, 5);
            s.AddRoad(12, 4, 18);
            s.AddRoad(12, 11, 1);
            s.AddRoad(10, 11, 1);
            s.AddRoad(9, 10, 1);
            s.AddRoad(8, 9, 1);
            s.AddRoad(8, 7, 1);
            s.AddRoad(6, 7, 1);
            s.AddRoad(6, 5, 1);
            s.AddRoad(5, 4, 1);
            s.AddRoad(4, 5, 3);
            s.AddRoad(3, 4, 1);
            Assert.Equal(new List<int> { 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 }, s.Create(1, 12));
        }

        [Fact]
        [Points("6-4.4")]
        public void TestSmallGraphWithLargeDistances()
        {
            ShortestPath s = new ShortestPath(5);
            s.AddRoad(1, 2, 17);
            s.AddRoad(2, 4, 12);
            s.AddRoad(1, 3, 16);
            s.AddRoad(3, 4, 15);
            s.AddRoad(4, 5, 13);
            Assert.Equal(new List<int> { 5, 4, 2, 1 }, s.Create(5, 1));
        }
    }
}
