namespace ProgramTests
{
    using Xunit;
    using Exercise003;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("6-3.1")]
        public void TestExample()
        {
            FloydWarshall fw = new FloydWarshall(5);
            fw.AddRoad(1, 2, 7);
            fw.AddRoad(2, 4, 2);
            fw.AddRoad(1, 3, 6);
            fw.AddRoad(3, 4, 5);
            fw.AddRoad(4, 5, 3);
            Assert.Equal(12, fw.Calculate(1, 5));
        }

        [Fact]
        [Points("6-3.1")]
        public void TestNoConnectionFoundReturnsMinusOne()
        {
            FloydWarshall fw = new FloydWarshall(5);
            fw.AddRoad(1, 2, 7);
            fw.AddRoad(2, 4, 2);
            fw.AddRoad(1, 3, 6);
            fw.AddRoad(3, 4, 5);
            Assert.Equal(-1, fw.Calculate(1, 5));
        }

        [Fact]
        [Points("6-3.1")]
        public void TestSingleNodeAndConnection()
        {
            FloydWarshall fw = new FloydWarshall(1);
            fw.AddRoad(1, 1, 1);
            Assert.Equal(1, fw.Calculate(1, 1));
        }

        [Fact]
        [Points("6-3.1")]
        public void TestAllRoadsLeadToOne()
        {
            FloydWarshall fw = new FloydWarshall(4);
            fw.AddRoad(2, 1, 1);
            fw.AddRoad(3, 1, 1);
            fw.AddRoad(4, 1, 3);
            Assert.Equal(3, fw.Calculate(1, 4));
        }

        [Fact]
        [Points("6-3.1")]
        public void TestLongestRoadIsTheDirectOne()
        {
            FloydWarshall fw = new FloydWarshall(4);
            fw.AddRoad(1, 4, 7);
            fw.AddRoad(1, 2, 2);
            fw.AddRoad(2, 3, 2);
            fw.AddRoad(3, 4, 2);
            Assert.Equal(6, fw.Calculate(1, 4));
        }

        [Fact]
        [Points("6-3.2")]
        public void TestLargerGraph()
        {
            FloydWarshall fw = new FloydWarshall(8);
            fw.AddRoad(1, 4, 7);
            fw.AddRoad(1, 2, 2);
            fw.AddRoad(2, 3, 3);
            fw.AddRoad(3, 4, 4);
            fw.AddRoad(5, 2, 5);
            fw.AddRoad(5, 6, 1);
            fw.AddRoad(8, 2, 4);
            fw.AddRoad(8, 7, 2);
            Assert.Equal(8, fw.Calculate(1, 7));
        }

        [Fact]
        [Points("6-3.2")]
        public void TestLargerGraphNoConnection()
        {
            FloydWarshall fw = new FloydWarshall(8);
            fw.AddRoad(1, 4, 7);
            fw.AddRoad(1, 2, 2);
            fw.AddRoad(2, 3, 3);
            fw.AddRoad(3, 4, 4);
            fw.AddRoad(5, 2, 5);
            fw.AddRoad(5, 6, 1);
            fw.AddRoad(8, 2, 4);
            Assert.Equal(-1, fw.Calculate(1, 7));
        }

        [Fact]
        [Points("6-3.2")]
        public void TestAllRoadsExist()
        {
            FloydWarshall fw = new FloydWarshall(4);
            fw.AddRoad(1, 2, 1);
            fw.AddRoad(1, 3, 2);
            fw.AddRoad(4, 1, 3);
            fw.AddRoad(2, 3, 1);
            fw.AddRoad(4, 2, 2);
            fw.AddRoad(3, 4, 1);
            Assert.Equal(3, fw.Calculate(1, 4));
        }

        [Fact]
        [Points("6-3.2")]
        public void TestMissingRoad()
        {
            FloydWarshall fw = new FloydWarshall(4);
            fw.AddRoad(1, 2, 1);
            fw.AddRoad(1, 3, 2);
            fw.AddRoad(4, 1, 3);
            fw.AddRoad(4, 2, 2);
            fw.AddRoad(3, 4, 1);
            Assert.Equal(3, fw.Calculate(2, 3));
        }
    }
}
