namespace ProgramTests
{
    using Xunit;
    using Exercise001;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("6-1.1")]
        public void TestConnectionExample()
        {
            BellmanFord bf1 = new BellmanFord(5);
            bf1.AddRoad(1, 2, 7);
            bf1.AddRoad(2, 4, 2);
            bf1.AddRoad(1, 3, 6);
            bf1.AddRoad(3, 4, 5);
            bf1.AddRoad(4, 5, 3);
            Assert.Equal(12, bf1.Calculate(1, 5));
        }

        [Fact]
        [Points("6-1.1")]
        public void TestNoConnectionExample()
        {
            BellmanFord bf2 = new BellmanFord(7);
            bf2.AddRoad(1, 2, 7);
            bf2.AddRoad(2, 4, 2);
            bf2.AddRoad(1, 3, 6);
            bf2.AddRoad(3, 4, 5);
            bf2.AddRoad(4, 5, 3);
            bf2.AddRoad(6, 7, 3);
            Assert.Equal(-1, bf2.Calculate(1, 7));
        }

        [Fact]
        [Points("6-1.1")]
        public void TestSmallGraphConnection()
        {
            BellmanFord bf1 = new BellmanFord(4);
            bf1.AddRoad(1, 2, 7);
            bf1.AddRoad(2, 3, 15);
            bf1.AddRoad(1, 3, 6);
            bf1.AddRoad(1, 4, 5);
            Assert.Equal(13, bf1.Calculate(2, 3));
        }

        [Fact]
        [Points("6-1.1")]
        public void TestSmallGraphNoConnections()
        {
            BellmanFord bf2 = new BellmanFord(4);
            Assert.Equal(-1, bf2.Calculate(1, 2));
            Assert.Equal(-1, bf2.Calculate(2, 3));
            Assert.Equal(-1, bf2.Calculate(3, 4));
            Assert.Equal(-1, bf2.Calculate(1, 4));
        }

        [Fact]
        [Points("6-1.2")]
        public void TestLargeGraphNoConnections()
        {
            BellmanFord bf2 = new BellmanFord(42);
            Assert.Equal(-1, bf2.Calculate(1, 24));
            Assert.Equal(-1, bf2.Calculate(22, 39));
            Assert.Equal(-1, bf2.Calculate(3, 42));
            Assert.Equal(-1, bf2.Calculate(1, 14));
        }

        [Fact]
        [Points("6-1.2")]
        public void TestLargeGraphWithConnections()
        {
            BellmanFord bf2 = new BellmanFord(14);
            bf2.AddRoad(1, 2, 7);
            bf2.AddRoad(2, 4, 2);
            bf2.AddRoad(1, 3, 6);
            bf2.AddRoad(3, 4, 5);
            bf2.AddRoad(4, 5, 3);
            bf2.AddRoad(6, 7, 3);
            bf2.AddRoad(1, 12, 8);
            bf2.AddRoad(12, 4, 22);
            bf2.AddRoad(11, 3, 6);
            bf2.AddRoad(3, 14, 5);
            bf2.AddRoad(14, 5, 3);
            bf2.AddRoad(6, 7, 13);
            Assert.Equal(11, bf2.Calculate(1, 14));
        }

        [Fact]
        [Points("6-1.2")]
        public void TestSmallConnectionsMissed()
        {
            BellmanFord bf2 = new BellmanFord(14);
            bf2.AddRoad(1, 2, 7);
            bf2.AddRoad(2, 4, 2);
            bf2.AddRoad(1, 3, 6);
            bf2.AddRoad(3, 4, 5);
            bf2.AddRoad(4, 5, 3);
            bf2.AddRoad(6, 7, 3);
            bf2.AddRoad(1, 12, 8);
            bf2.AddRoad(12, 4, 22);
            bf2.AddRoad(11, 3, 6);
            bf2.AddRoad(3, 14, 5);
            bf2.AddRoad(14, 5, 3);
            bf2.AddRoad(6, 7, 13);
            Assert.Equal(-1, bf2.Calculate(13, 14));
        }

        [Fact]
        [Points("6-1.2")]
        public void TestSingleNodeReturnsZero()
        {
            BellmanFord bf2 = new BellmanFord(1);
            Assert.Equal(0, bf2.Calculate(1, 1));
        }
    }
}
