namespace ProgramTests
{
    using Xunit;
    using Exercise002;
    using TestMyCode.CSharp.API.Attributes;

    public partial class ProgramTest
    {
        [Fact]
        [Points("6-2.1")]
        public void TestExample()
        {
            Dijkstra d = new Dijkstra(6);
            d.AddRoad(1, 2, 7);
            d.AddRoad(2, 4, 2);
            d.AddRoad(1, 3, 6);
            d.AddRoad(3, 4, 5);
            d.AddRoad(4, 5, 3);
            Assert.Equal(12, d.Calculate(1, 5));
        }

        [Fact]
        [Points("6-2.1")]
        public void TestAnothesSmallGraph()
        {
            Dijkstra d = new Dijkstra(8);
            d.AddRoad(1, 2, 7);
            d.AddRoad(1, 8, 18);
            d.AddRoad(2, 4, 2);
            d.AddRoad(1, 3, 6);
            d.AddRoad(3, 4, 5);
            d.AddRoad(7, 6, 2);
            d.AddRoad(8, 5, 3);
            d.AddRoad(4, 5, 3);
            Assert.Equal(15, d.Calculate(1, 8));
        }

        [Fact]
        [Points("6-2.1")]
        public void TestSmallGraphLongDistances()
        {
            Dijkstra d = new Dijkstra(8);
            d.AddRoad(1, 2, 12);
            d.AddRoad(1, 8, 123);
            d.AddRoad(2, 4, 23);
            d.AddRoad(1, 3, 16);
            d.AddRoad(3, 4, 52);
            d.AddRoad(7, 6, 21);
            d.AddRoad(8, 5, 32);
            d.AddRoad(4, 5, 13);
            Assert.Equal(80, d.Calculate(1, 8));
        }

        [Fact]
        [Points("6-2.1")]
        public void TestSingleNodeAloneReturnsZero()
        {
            Dijkstra d = new Dijkstra(1);
            Assert.Equal(0, d.Calculate(1, 1));
        }

        [Fact]
        [Points("6-2.2")]
        public void TestLargeGraphWithLargeDistances()
        {
            Dijkstra d = new Dijkstra(15);
            d.AddRoad(1, 2, 12);
            d.AddRoad(3, 2, 13);
            d.AddRoad(4, 2, 11);
            d.AddRoad(4, 5, 9);
            d.AddRoad(6, 5, 14);
            d.AddRoad(6, 7, 16);
            d.AddRoad(7, 10, 21);
            d.AddRoad(10, 9, 22);
            d.AddRoad(10, 8, 89);
            d.AddRoad(7, 12, 17);
            d.AddRoad(12, 11, 92);
            d.AddRoad(1, 12, 132);
            d.AddRoad(12, 13, 42);
            d.AddRoad(13, 14, 144);
            d.AddRoad(15, 8, 12);

            Assert.Equal(184, d.Calculate(1, 15));
        }

        [Fact]
        [Points("6-2.2")]
        public void TestLargeGraphWithSmallDistances()
        {
            Dijkstra d = new Dijkstra(15);
            d.AddRoad(1, 2, 1);
            d.AddRoad(3, 2, 2);
            d.AddRoad(4, 2, 4);
            d.AddRoad(4, 5, 9);
            d.AddRoad(6, 5, 5);
            d.AddRoad(6, 7, 2);
            d.AddRoad(7, 10, 7);
            d.AddRoad(10, 9, 6);
            d.AddRoad(10, 8, 3);
            d.AddRoad(7, 12, 4);
            d.AddRoad(12, 11, 1);
            d.AddRoad(1, 12, 9);
            d.AddRoad(12, 13, 5);
            d.AddRoad(13, 14, 3);
            d.AddRoad(15, 8, 3);
            Assert.Equal(26, d.Calculate(1, 15));
        }

        [Fact]
        [Points("6-2.2")]
        public void TestSmallGraphAllEdges()
        {
            Dijkstra d = new Dijkstra(5);
            d.AddRoad(1, 2, 1);
            d.AddRoad(1, 3, 2);
            d.AddRoad(1, 4, 3);
            d.AddRoad(1, 5, 4);
            d.AddRoad(2, 3, 1);
            d.AddRoad(2, 4, 2);
            d.AddRoad(2, 5, 3);
            d.AddRoad(3, 4, 1);
            d.AddRoad(3, 5, 2);
            d.AddRoad(4, 5, 1);
            Assert.Equal(4, d.Calculate(1, 5));
        }

        [Fact]
        [Points("6-2.2")]
        public void TestLargeGraphNoConnection()
        {
            Dijkstra d = new Dijkstra(15);
            d.AddRoad(1, 2, 1);
            d.AddRoad(3, 2, 2);
            d.AddRoad(4, 2, 4);
            d.AddRoad(4, 5, 9);
            d.AddRoad(6, 5, 5);
            d.AddRoad(6, 7, 2);
            d.AddRoad(7, 10, 7);
            d.AddRoad(10, 9, 6);
            d.AddRoad(10, 8, 3);
            d.AddRoad(7, 12, 4);
            d.AddRoad(12, 11, 1);
            d.AddRoad(1, 12, 9);
            d.AddRoad(12, 13, 5);
            d.AddRoad(13, 14, 3);
            Assert.Equal(-1, d.Calculate(1, 15));
        }
    }
}
