namespace ProgramTests
{
    using System;
    using System.IO;
    using Xunit;
    using Exercise002;
    using TestMyCode.CSharp.API.Attributes;

    public partial class ProgramTest
    {
        [Fact]
        [Points("3-2.1")]
        public void TestExampleWorks()
        {
            SmallestDifference s = new SmallestDifference();
            Assert.Equal(1, s.Calculate(new int[] { 4, 1, 8, 5 }));
            Assert.Equal(9, s.Calculate(new int[] { 1, 10, 100, 1000 }));
            Assert.Equal(0, s.Calculate(new int[] { 1, 1, 1, 1, 1 }));
        }

        [Fact]
        [Points("3-2.2")]
        public void TestLargeValuesWork()
        {
            SmallestDifference s = new SmallestDifference();
            Assert.Equal(10, s.Calculate(new int[] { 40, 10, 80, 50 }));
            Assert.Equal(0, s.Calculate(new int[] { 1000, 10000, 1000000, 1000, 1000, 100 }));
        }

        [Fact]
        [Points("3-2.2")]
        public void TestNItems()
        {
            SmallestDifference s = new SmallestDifference();
            Assert.Equal(1, s.Calculate(new int[] { 4, 1, 8, 5, 2, 3, 7, 6, 9, 10, 13, 12, 11 }));
        }

        [Fact]
        [Points("3-2.1")]
        public void TestBackwardsListWorks()
        {
            SmallestDifference s = new SmallestDifference();
            Assert.Equal(1, s.Calculate(new int[] { 9, 8, 7, 6, 5, 4, 3, 2, 1 }));
            Assert.Equal(9, s.Calculate(new int[] { 90, 80, 70, 60, 50, 40, 30, 20, 11 }));
        }

    }
}
