namespace ProgramTests
{
    using System;
    using System.IO;
    using Xunit;
    using Exercise001;
    using TestMyCode.CSharp.API.Attributes;
    using System.Linq;
    using Mono.Cecil;
    using Mono.Cecil.Cil;
    public partial class ProgramTest
    {
        [Fact]
        [Points("3-1.2")]
        public void TestHelloThree()
        {
            using (StringWriter sw = new StringWriter())
            {
                sw.NewLine = "\n";
                TextWriter stdout = Console.Out;
                Console.SetOut(sw);
                Program.Hello(3);
                Console.SetOut(stdout);

                Assert.Equal("Hello!\nHello!\nHello!\n", sw.ToString());
            }
        }
        [Fact]
        [Points("3-1.1")]
        public void TestExample()
        {
            using (StringWriter sw = new StringWriter())
            {
                sw.NewLine = "\n";
                TextWriter stdout = Console.Out;
                Console.SetOut(sw);
                Program.Hello(5);
                Console.SetOut(stdout);

                Assert.Equal("Hello!\nHello!\nHello!\nHello!\nHello!\n", sw.ToString());
            }
        }


        [Fact]
        [Points("3-1.2")]
        public void CountHelloUsesSingleWriteLine()
        {
            int counter = 0;
            Mono.Cecil.AssemblyDefinition assembly = Mono.Cecil.AssemblyDefinition.ReadAssembly(typeof(Program).Module.FullyQualifiedName);
            Mono.Cecil.TypeDefinition type = assembly.MainModule.GetType(typeof(Program).FullName);

            Mono.Cecil.MethodDefinition method = null;
            foreach (Mono.Cecil.MethodDefinition iter in type.Methods)
            {
                if (iter.Name == "Hello")
                {
                    method = iter;
                }
            }

            foreach (Mono.Cecil.Cil.Instruction instruction in method.Body.Instructions)
            {
                if (instruction.OpCode != Mono.Cecil.Cil.OpCodes.Call)
                {
                    continue;
                }

                if (instruction.Operand is not Mono.Cecil.MethodReference methodReference)
                {
                    continue;
                }

                if (methodReference.FullName == "System.Void System.Console::WriteLine(System.String)")
                {
                    counter++;
                }
            }
            Assert.Equal(1, counter);
        }

        [Fact]
        [Points("3-1.1")]
        public void TestHelloCallsItself()
        {
            int counter = 0;
            Mono.Cecil.AssemblyDefinition assembly = Mono.Cecil.AssemblyDefinition.ReadAssembly(typeof(Program).Module.FullyQualifiedName);
            Mono.Cecil.TypeDefinition type = assembly.MainModule.GetType(typeof(Program).FullName);

            Mono.Cecil.MethodDefinition method = null;
            foreach (Mono.Cecil.MethodDefinition iter in type.Methods)
            {
                if (iter.Name == "Hello")
                {
                    method = iter;
                }
            }

            foreach (Mono.Cecil.Cil.Instruction instruction in method.Body.Instructions)
            {
                if (instruction.OpCode != Mono.Cecil.Cil.OpCodes.Call)
                {
                    continue;
                }

                if (instruction.Operand is not Mono.Cecil.MethodReference methodReference)
                {
                    continue;
                }

                if (methodReference.FullName == "System.Void Exercise001.Program::Hello(System.Int32)")
                {
                    counter++;
                }
            }
            Assert.Equal(1, counter);
        }
    }
}
