namespace ProgramTests
{
    using System;
    using System.IO;
    using Xunit;
    using Exercise004;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("3-4.1")]
        public void TestReturnsTrue()
        {
            using (StringWriter sw = new StringWriter())
            {
                BinarySearch b = new BinarySearch();
                Assert.True(b.Find(new int[] { 0, 0 }, 0));
                Assert.True(b.Find(new int[] { 4, 1, 8, 5, 8, 7, 4, 2, 3 }, 2));
                Assert.True(b.Find(new int[] { 0 }, 0));
            }
        }

        [Fact]
        [Points("3-4.1")]
        public void TestReturnsFalse()
        {
            using (StringWriter sw = new StringWriter())
            {
                BinarySearch b = new BinarySearch();
                Assert.False(b.Find(new int[] { 4, 1, 8, 5, 6, 12, 7 }, 2));
            }
        }

        [Fact]
        [Points("3-4.1")]
        public void SingleValueArrayWorksFalse()
        {
            using (StringWriter sw = new StringWriter())
            {
                BinarySearch b = new BinarySearch();
                Assert.False(b.Find(new int[] { 1 }, 2));
            }
        }

        [Fact]
        [Points("3-4.2")]
        public void DoubleArrayWorksTrue()
        {
            using (StringWriter sw = new StringWriter())
            {
                BinarySearch b = new BinarySearch();
                Assert.True(b.Find(new int[] { 2, 2 }, 2));
            }
        }
        [Fact]
        [Points("3-4.1")]
        public void DoubleArrayWorksFalse()
        {
            using (StringWriter sw = new StringWriter())
            {
                BinarySearch b = new BinarySearch();
                Assert.False(b.Find(new int[] { 3, 3 }, 5));
            }
        }

        [Fact]
        [Points("3-4.2")]
        public void SingleValueArrayWorksTrue()
        {
            using (StringWriter sw = new StringWriter())
            {
                BinarySearch b = new BinarySearch();
                Assert.True(b.Find(new int[] { 2 }, 2));
            }
        }

        [Fact]
        [Points("3-4.2")]
        public void TestReturnsTrueLargerArray()
        {
            using (StringWriter sw = new StringWriter())
            {
                BinarySearch b = new BinarySearch();
                Assert.True(b.Find(new int[] { 4, 1, 8, 5, 8, 7, 4, 2, 3, 12, 864, 4516, 645, 64, 15, 152, 843, 41, 1, 4, 2, 1 }, 2));
            }
        }

        [Fact]
        [Points("3-4.2")]
        public void TestReturnsFalseLargerArray()
        {
            using (StringWriter sw = new StringWriter())
            {
                BinarySearch b = new BinarySearch();
                Assert.False(b.Find(new int[] { 4, 1, 8, 5, 6, 12, 7, 1, 1, 1, 1, 1, 1, 1, 5, 4, 7, 5, 8, 9 }, 2));
            }
        }
    }
}
