namespace ProgramTests
{
    using System;
    using System.Collections.Generic;
    using Xunit;
    using Exercise005;
    using TestMyCode.CSharp.API.Attributes;
    using System.Linq;
    public partial class ProgramTest
    {
        [Fact]
        [Points("3-5.1")]
        public void CountInversionsInExampleTen()
        {
            Inversions inv = new Inversions();
            int[] array = inv.Create(10, 45);
            int[] actual = { 10, 9, 8, 7, 6, 5, 4, 3, 2, 1 };
            Assert.True(actual.SequenceEqual(array));
        }

        [Fact]
        [Points("3-5.1")]
        public void CountSimpleInversion()
        {
            Inversions inv = new Inversions();
            int[] array = inv.Create(2, 1);
            int[] actual = { 2, 1 };
            Assert.True(actual.SequenceEqual(array));
        }

        [Fact]
        [Points("3-5.1")]
        public void CreateNoInversions()
        {
            Inversions inv = new Inversions();
            int[] array = inv.Create(5, 0);
            int[] actual = { 1, 2, 3, 4, 5 };
            Assert.True(actual.SequenceEqual(array));
        }

        [Fact]
        [Points("3-5.1")]
        public void TenInversionsInFiveArray()
        {
            Inversions inv = new Inversions();
            int[] array = inv.Create(5, 10);
            Assert.Equal(10, Inversions(array));
        }

        [Fact]
        [Points("3-5.2")]
        public void CreateInverseList()
        {
            Inversions inv = new Inversions();
            int[] array = inv.Create(6, 15);
            int[] actual = { 6, 5, 4, 3, 2, 1 };
            Assert.True(actual.SequenceEqual(array));
        }

        [Fact]
        [Points("3-5.2")]
        public void CreateThreeInversions()
        {
            Inversions inv = new Inversions();
            int[] array = inv.Create(6, 3);
            Assert.Equal(3, Inversions(array));
        }

        [Fact]
        [Points("3-5.2")]
        public void CreateSixInversions()
        {
            Inversions inv = new Inversions();
            int[] array = inv.Create(6, 6);
            Assert.Equal(6, Inversions(array));
        }

        [Fact]
        [Points("3-5.2")]
        public void NineInversionsInTenArray()
        {
            Inversions inv = new Inversions();
            int[] array = inv.Create(10, 9);
            Assert.Equal(9, Inversions(array));
        }


        private int Inversions(int[] a)
        {
            return Helper(a, 0, a.Length - 1);
        }

        private int Helper(int[] a, int l, int h)
        {
            var c = 0;
            if (h > l)
            {
                var m = (h - l) / 2 + l;
                c += Helper(a, l, m);
                c += Helper(a, m + 1, h);
                c += Final(a, l, m + 1, h);
            }
            return c;
        }

        private int Final(int[] a, int l, int m, int h)
        {
            int c = 0;
            List<int> t = new List<int>();
            int i = l, j = m;
            while (i < m && j <= h)
            {
                if (a[i] <= a[j])
                {
                    t.Add(a[i]);
                    i++;
                }
                else
                {
                    c += (m - i);
                    t.Add(a[j]);
                    j++;
                }
            }
            while (i < m)
            {
                t.Add(a[i++]);
            }
            while (j <= h)
            {
                t.Add(a[j++]);
            }
            int s = l;
            foreach (int v in t)
            {
                a[s++] = v;
            }
            return c;
        }
    }
}
