namespace ProgramTests
{
    using System;
    using System.IO;
    using Xunit;
    using Exercise003;
    using TestMyCode.CSharp.API.Attributes;
    using System.Linq;
    using Mono.Cecil;
    using Mono.Cecil.Cil;

    public partial class ProgramTest
    {
        [Fact]
        [Points("3-3.1")]
        public void TestTenItemsMergeSort()
        {
            int[] arr = { 28, 971, 230, 662, 356, 822, 243, 161, 93, 29 };
            Sorting s = new Sorting();
            int[] sorted = s.MergeSort(arr);
            Array.Sort(arr);
            Assert.True(arr.SequenceEqual(sorted));
        }

        [Fact]
        [Points("3-3.1")]
        public void TestElevenItemMergeSort()
        {
            int[] arr = { 28, 972, 230, 662, 356, 882, 243, 161, 93, 29, 1 };
            Sorting s = new Sorting();
            int[] sorted = s.MergeSort(arr);
            int[] actual = { 1, 28, 29, 93, 161, 230, 243, 356, 662, 882, 972 };
            Assert.True(actual.SequenceEqual(sorted));
        }

        [Fact]
        [Points("3-3.2")]
        public void TestTenItemsQuickSort()
        {
            int[] arr = { 28, 971, 231, 662, 356, 822, 243, 161, 93, 29 };
            Sorting s = new Sorting();
            int[] sorted = s.QuickSort(arr, 0, arr.Length - 1);
            Array.Sort(arr);
            Assert.True(arr.SequenceEqual(sorted));
        }

        [Fact]
        [Points("3-3.2")]
        public void TestElevenItemQuickSort()
        {
            int[] arr = { 28, 97, 23, 66, 35, 88, 24, 16, 93, 29, 1 };
            Sorting s = new Sorting();
            int[] sorted = s.QuickSort(arr, 0, arr.Length - 1);
            int[] actual = { 1, 16, 23, 24, 28, 29, 35, 66, 88, 93, 97 };
            Assert.True(actual.SequenceEqual(sorted));
        }

        [Fact]
        [Points("3-3.1")]
        public void TestMergeSortCallsItselfTwice()
        {
            int counter = 0;
            Mono.Cecil.AssemblyDefinition assembly = Mono.Cecil.AssemblyDefinition.ReadAssembly(typeof(Program).Module.FullyQualifiedName);
            Mono.Cecil.TypeDefinition type = null;
            foreach (TypeDefinition iter in assembly.MainModule.Types)
            {
                if (iter.Name == "Sorting")
                {
                    type = iter;
                }
            }
            Mono.Cecil.MethodDefinition method = null;
            foreach (Mono.Cecil.MethodDefinition iter in type.Methods)
            {
                if (iter.Name == "MergeSort")
                {
                    method = iter;
                }
            }

            foreach (Mono.Cecil.Cil.Instruction instruction in method.Body.Instructions)
            {
                if (instruction.OpCode != Mono.Cecil.Cil.OpCodes.Call)
                {
                    continue;
                }

                if (instruction.Operand is not Mono.Cecil.MethodReference methodReference)
                {
                    continue;
                }

                if (methodReference.FullName == "System.Int32[] Exercise003.Sorting::MergeSort(System.Int32[])")
                {
                    counter++;
                }
            }
            Assert.Equal(2, counter);
        }

        [Fact]
        [Points("3-3.1")]
        public void TestMergeSortCallsMergeOnce()
        {
            int counter = 0;
            Mono.Cecil.AssemblyDefinition assembly = Mono.Cecil.AssemblyDefinition.ReadAssembly(typeof(Program).Module.FullyQualifiedName);
            Mono.Cecil.TypeDefinition type = null;
            foreach (TypeDefinition iter in assembly.MainModule.Types)
            {
                if (iter.Name == "Sorting")
                {
                    type = iter;
                }
            }
            Mono.Cecil.MethodDefinition method = null;
            foreach (Mono.Cecil.MethodDefinition iter in type.Methods)
            {
                if (iter.Name == "MergeSort")
                {
                    method = iter;
                }
            }

            foreach (Mono.Cecil.Cil.Instruction instruction in method.Body.Instructions)
            {
                if (instruction.OpCode != Mono.Cecil.Cil.OpCodes.Call)
                {
                    continue;
                }

                if (instruction.Operand is not Mono.Cecil.MethodReference methodReference)
                {
                    continue;
                }

                if (methodReference.FullName == "System.Int32[] Exercise003.Sorting::Merge(System.Int32[],System.Int32[])")
                {
                    counter++;
                }
            }
            Assert.Equal(1, counter);
        }

        [Fact]
        [Points("3-3.2")]
        public void TestQuickSortCallsItselfTwice()
        {
            int counter = 0;
            Mono.Cecil.AssemblyDefinition assembly = Mono.Cecil.AssemblyDefinition.ReadAssembly(typeof(Program).Module.FullyQualifiedName);
            Mono.Cecil.TypeDefinition type = null;
            foreach (TypeDefinition iter in assembly.MainModule.Types)
            {
                if (iter.Name == "Sorting")
                {
                    type = iter;
                }
            }
            Mono.Cecil.MethodDefinition method = null;
            foreach (Mono.Cecil.MethodDefinition iter in type.Methods)
            {
                if (iter.Name == "QuickSort")
                {
                    method = iter;
                }
            }

            foreach (Mono.Cecil.Cil.Instruction instruction in method.Body.Instructions)
            {
                if (instruction.OpCode != Mono.Cecil.Cil.OpCodes.Call)
                {
                    continue;
                }

                if (instruction.Operand is not Mono.Cecil.MethodReference methodReference)
                {
                    continue;
                }

                if (methodReference.FullName == "System.Int32[] Exercise003.Sorting::QuickSort(System.Int32[],System.Int32,System.Int32)")
                {
                    counter++;
                }
            }
            Assert.Equal(2, counter);
        }

        [Fact]
        [Points("3-3.1")]
        public void TestQuickSortCallsPivotOnce()
        {
            int counter = 0;
            Mono.Cecil.AssemblyDefinition assembly = Mono.Cecil.AssemblyDefinition.ReadAssembly(typeof(Program).Module.FullyQualifiedName);
            Mono.Cecil.TypeDefinition type = null;
            foreach (TypeDefinition iter in assembly.MainModule.Types)
            {
                if (iter.Name == "Sorting")
                {
                    type = iter;
                }
            }
            Mono.Cecil.MethodDefinition method = null;
            foreach (Mono.Cecil.MethodDefinition iter in type.Methods)
            {
                if (iter.Name == "QuickSort")
                {
                    method = iter;
                }
            }

            foreach (Mono.Cecil.Cil.Instruction instruction in method.Body.Instructions)
            {
                if (instruction.OpCode != Mono.Cecil.Cil.OpCodes.Call)
                {
                    continue;
                }

                if (instruction.Operand is not Mono.Cecil.MethodReference methodReference)
                {
                    continue;
                }

                if (methodReference.FullName == "System.Int32 Exercise003.Sorting::Pivot(System.Int32[],System.Int32,System.Int32)")
                {
                    counter++;
                }
            }
            Assert.Equal(1, counter);
        }


        [Fact]
        [Points("3-3.1")]
        public void TestNoSystemSortIsUsedInQuickSort()
        {
            int counter = 0;
            Mono.Cecil.AssemblyDefinition assembly = Mono.Cecil.AssemblyDefinition.ReadAssembly(typeof(Program).Module.FullyQualifiedName);
            Mono.Cecil.TypeDefinition type = null;
            foreach (TypeDefinition iter in assembly.MainModule.Types)
            {
                if (iter.Name == "Sorting")
                {
                    type = iter;
                }
            }
            Mono.Cecil.MethodDefinition method = null;
            foreach (Mono.Cecil.MethodDefinition iter in type.Methods)
            {
                if (iter.Name == "QuickSort")
                {
                    method = iter;
                }
            }

            foreach (Mono.Cecil.Cil.Instruction instruction in method.Body.Instructions)
            {
                if (instruction.OpCode != Mono.Cecil.Cil.OpCodes.Call)
                {
                    continue;
                }

                if (instruction.Operand is not Mono.Cecil.MethodReference methodReference)
                {
                    continue;
                }

                if (methodReference.FullName.Contains("System.Array::Sort"))
                {
                    counter++;
                }
            }
            Assert.Equal(0, counter);
        }

        [Fact]
        [Points("3-3.2")]
        public void TestNoSystemSortIsUsedInMergeSort()
        {
            int counter = 0;
            Mono.Cecil.AssemblyDefinition assembly = Mono.Cecil.AssemblyDefinition.ReadAssembly(typeof(Program).Module.FullyQualifiedName);
            Mono.Cecil.TypeDefinition type = null;
            foreach (TypeDefinition iter in assembly.MainModule.Types)
            {
                if (iter.Name == "Sorting")
                {
                    type = iter;
                }
            }
            Mono.Cecil.MethodDefinition method = null;
            foreach (Mono.Cecil.MethodDefinition iter in type.Methods)
            {
                if (iter.Name == "MergeSort")
                {
                    method = iter;
                }
            }

            foreach (Mono.Cecil.Cil.Instruction instruction in method.Body.Instructions)
            {
                if (instruction.OpCode != Mono.Cecil.Cil.OpCodes.Call)
                {
                    continue;
                }

                if (instruction.Operand is not Mono.Cecil.MethodReference methodReference)
                {
                    continue;
                }

                if (methodReference.FullName.Contains("System.Array::Sort"))
                {
                    counter++;
                }
            }
            Assert.Equal(0, counter);
        }
    }
}