namespace ProgramTests
{
    using Xunit;
    using Exercise002;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("1-2.1")]
        public void TestExample()
        {
            Substrings subs = new Substrings();
            Assert.Equal(1, subs.Calculate("aybabtu", "bab"));
            Assert.Equal(4, subs.Calculate("aaaaa", "aa"));
            Assert.Equal(0, subs.Calculate("monkey", "banana"));
        }

        [Fact]
        [Points("1-2.1")]
        public void TestSingleLetters()
        {
            Substrings subs = new Substrings();
            Assert.Equal(10, subs.Calculate("bbbbbbbbbbb", "bb"));
            Assert.Equal(1, subs.Calculate("cccccccdccccc", "d"));
            Assert.Equal(11, subs.Calculate("cccccccccccc", "cc"));
            Assert.Equal(10, subs.Calculate("cccccccccccc", "ccc"));
            Assert.Equal(9, subs.Calculate("cccccccccccc", "cccc"));
        }

        [Fact]
        [Points("1-2.2")]
        public void TestSentences()
        {
            Substrings subs = new Substrings();
            Assert.Equal(5, subs.Calculate("this is a sentence with some words", "s"));
            Assert.Equal(4, subs.Calculate("this is another sentence with some words, this is indeed.", "is"));
            Assert.Equal(6, subs.Calculate("here is yet another sentence with spaces and words and ands and hands and all", "and"));
            Assert.Equal(3, subs.Calculate("i bet you can find youthful people from youngsters", "you"));
        }

        [Fact]
        [Points("1-2.2")]
        public void TestSentencesNoMatches()
        {
            Substrings subs = new Substrings();
            Assert.Equal(0, subs.Calculate("this is a sentence with some words", "there"));
            Assert.Equal(0, subs.Calculate("this is another sentence with some words, this is indeed.", "potato"));
            Assert.Equal(0, subs.Calculate("here is yet another sentence with spaces and words and ands and hands and all", "www"));
            Assert.Equal(0, subs.Calculate("i bet you can find youthful people from youngsters", "old"));
        }

    }
}
