namespace ProgramTests
{
    using Xunit;
    using Exercise004;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("1-4.1")]
        public void TestExample()
        {
            LuckyNumbers luck = new LuckyNumbers();
            Assert.Equal(2, luck.Calculate(1, 10)); // 2
            Assert.Equal(0, luck.Calculate(123, 321)); // 0
            Assert.Equal(126, luck.Calculate(1, 1000000)); // 126  
            Assert.Equal(1016, luck.Calculate(120, 1000000000)); // 1016  
        }

        [Fact]
        [Points("1-4.1")]
        public void TestOtherValues()
        {
            LuckyNumbers luck = new LuckyNumbers();
            Assert.Equal(2, luck.Calculate(1, 11)); // 2
            Assert.Equal(0, luck.Calculate(123, 322)); // 0
            Assert.Equal(126, luck.Calculate(1, 1000001)); // 126  
            Assert.Equal(1016, luck.Calculate(120, 1000000001)); // 1016  
        }

        [Fact]
        [Points("1-4.2")]
        public void TestModifiedExample()
        {
            LuckyNumbers luck = new LuckyNumbers();
            Assert.Equal(2, luck.Calculate(3, 10));
            Assert.Equal(1, luck.Calculate(77, 321));
            Assert.Equal(125, luck.Calculate(4, 1000000));
            Assert.Equal(1022, luck.Calculate(1, 1000000000));
        }

        [Fact]
        [Points("1-4.2")]
        public void TestAnotherModifiedExample()
        {
            LuckyNumbers luck = new LuckyNumbers();
            Assert.Equal(1, luck.Calculate(7, 10));
            Assert.Equal(0, luck.Calculate(78, 321));
            Assert.Equal(124, luck.Calculate(8, 1000000));
            Assert.Equal(1021, luck.Calculate(4, 1000000000));
        }

        [Fact]
        [Points("1-4.3")]
        public void TestLargerStartingValues()
        {
            LuckyNumbers luck = new LuckyNumbers();
            Assert.Equal(6, luck.Calculate(334, 776));
            Assert.Equal(240, luck.Calculate(778, 7777777));
            Assert.Equal(488, luck.Calculate(6874, 78641651));
            Assert.Equal(764, luck.Calculate(8, 546213879));
        }

        [Fact]
        [Points("1-4.3")]
        public void TestLargerStartingValuesWithExample()
        {
            LuckyNumbers luck = new LuckyNumbers();
            Assert.Equal(0, luck.Calculate(9, 10));
            Assert.Equal(0, luck.Calculate(300, 321)); // 0
            Assert.Equal(120, luck.Calculate(100, 1000000)); // 126  
            Assert.Equal(1008, luck.Calculate(1200, 1000000000)); // 1016  
        }

        [Fact]
        [Points("1-4.4")]
        public void TestImpossibleValues()
        {
            LuckyNumbers luck = new LuckyNumbers();
            Assert.Equal(0, luck.Calculate(77, 7));
            Assert.Equal(0, luck.Calculate(3, 2));
            Assert.Equal(0, luck.Calculate(7, 3));
            Assert.Equal(0, luck.Calculate(0, 0));
            Assert.Equal(0, luck.Calculate(-77, 0));
            Assert.Equal(0, luck.Calculate(-77, -33));
        }

        [Fact]
        [Points("1-4.4")]
        public void TestNearImpossibleValues()
        {
            LuckyNumbers luck = new LuckyNumbers();
            Assert.Equal(1, luck.Calculate(77, 78));
            Assert.Equal(1, luck.Calculate(3, 3));
            Assert.Equal(1, luck.Calculate(7, 7));
            Assert.Equal(5, luck.Calculate(7, 77));
            Assert.Equal(1, luck.Calculate(-77, 3));
            Assert.Equal(1, luck.Calculate(-77, 3));
        }
    }
}
