namespace ProgramTests
{
    using Xunit;
    using Exercise003;
    using TestMyCode.CSharp.API.Attributes;

    public partial class ProgramTest
    {
        [Fact]
        [Points("1-3.1")]
        public void TestExample()
        {
            Tables t = new Tables();
            Assert.Equal(18, t.Calculate(new int[] { 1, 2, 3, 2 }));
            Assert.Equal(5, t.Calculate(new int[] { 5 }));
            Assert.Equal(323, t.Calculate(new int[] { 4, 2, 9, 1, 9, 2, 5 }));
        }

        [Fact]
        [Points("1-3.1")]
        public void TestSingleValueArrays()
        {
            Tables t = new Tables();
            Assert.Equal(64, t.Calculate(new int[] { 1, 1, 1, 1, 1, 1, 1 }));
            Assert.Equal(9, t.Calculate(new int[] { 9 }));
            Assert.Equal(128, t.Calculate(new int[] { 2, 2, 2, 2, 2, 2, 2 }));
        }

        [Fact]
        [Points("1-3.2")]
        public void TestLargeArrays()
        {
            Tables t = new Tables();
            Assert.Equal(1683675539, t.Calculate(new int[] { 4, 2, 9, 1, 9, 2, 5, 4, 2, 9, 1, 9, 2, 5, 4, 2, 9, 1, 9, 2, 5, 4, 2, 9, 1, 9, 2, 5, 4, 2, 9, 1, 9, 2, 5 }));
            Assert.Equal(65169, t.Calculate(new int[] { 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 2, 1, 2, 1, 2, 2 }));
            Assert.Equal(2097152, t.Calculate(new int[] { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }));
        }
        [Fact]
        [Points("1-3.2")]
        public void TestLargerThanSingleDigits()
        {
            Tables t = new Tables();
            Assert.Equal(710, t.Calculate(new int[] { 11, 11, 11, 11, 11, 12, 11 }));
            Assert.Equal(9999, t.Calculate(new int[] { 9999 }));
            Assert.Equal(361344, t.Calculate(new int[] { 11, 234, 2123, 1112, 1221, 11111, 12, 42 }));
        }
    }
}