namespace ProgramTests
{
    using System;
    using System.IO;
    using Xunit;
    using Exercise001;
    using TestMyCode.CSharp.API.Attributes;

    public partial class ProgramTest
    {
        [Fact]
        [Points("5-1.2")]
        public void TestExample()
        {
            Connectivity c = new Connectivity(10);
            c.AddConnection(1, 2);
            c.AddConnection(2, 3);
            c.AddConnection(1, 3);
            c.AddConnection(5, 4);
            c.AddConnection(5, 6);
            c.AddConnection(5, 7);
            c.AddConnection(7, 8);
            c.AddConnection(6, 9);
            c.AddConnection(9, 10);
            Assert.Equal(6, c.Calculate(5)); // 6
        }

        [Fact]
        [Points("5-1.2")]
        public void TestLargerNetwork()
        {
            Connectivity c = new Connectivity(100);
            c.AddConnection(1, 2);
            c.AddConnection(2, 3);
            c.AddConnection(1, 3);
            c.AddConnection(5, 4);
            c.AddConnection(5, 6);
            c.AddConnection(5, 7);
            c.AddConnection(7, 8);
            c.AddConnection(6, 9);
            c.AddConnection(9, 10);
            c.AddConnection(9, 12);
            c.AddConnection(9, 17);
            c.AddConnection(9, 27);
            c.AddConnection(9, 42);
            c.AddConnection(9, 78);
            c.AddConnection(9, 69);
            c.AddConnection(9, 89);
            c.AddConnection(9, 82);
            c.AddConnection(9, 14);
            c.AddConnection(23, 9);
            c.AddConnection(9, 56);
            c.AddConnection(9, 57);
            c.AddConnection(9, 99);
            c.AddConnection(9, 43);
            c.AddConnection(79, 9);
            c.AddConnection(9, 11);
            c.AddConnection(9, 13);
            c.AddConnection(9, 66);
            c.AddConnection(9, 54);
            c.AddConnection(9, 100);
            Assert.Equal(26, c.Calculate(100));
        }

        [Fact]
        [Points("5-1.2")]
        public void TestLargerNetworkNoConnections()
        {
            Connectivity c = new Connectivity(100);
            Assert.Equal(0, c.Calculate(100));
        }

        [Fact]
        [Points("5-1.2")]
        public void TestNetWorkWithManyConnections()
        {
            Connectivity c = new Connectivity(12);
            c.AddConnection(1, 2);
            c.AddConnection(12, 1);
            c.AddConnection(11, 2);
            c.AddConnection(11, 3);
            c.AddConnection(3, 10);
            c.AddConnection(10, 4);
            c.AddConnection(4, 5);
            c.AddConnection(5, 9);
            c.AddConnection(9, 6);
            c.AddConnection(7, 8);
            c.AddConnection(6, 8);
            Assert.Equal(11, c.Calculate(10));
        }

        [Fact]
        [Points("5-1.1")]
        public void TestSingleItemNetwork()
        {
            Connectivity c = new Connectivity(1);
            Assert.Equal(0, c.Calculate(1));
        }

        [Fact]
        [Points("5-1.1")]
        public void TestDuoNetworkOneToTwo()
        {
            Connectivity c = new Connectivity(2);
            c.AddConnection(1, 2);
            Assert.Equal(1, c.Calculate(1));
        }

        [Fact]
        [Points("5-1.1")]
        public void TestDuoNetworkTwoToOne()
        {
            Connectivity c = new Connectivity(2);
            c.AddConnection(2, 1);
            Assert.Equal(1, c.Calculate(1));
        }

        [Fact]
        [Points("5-1.1")]
        public void TestSimpleNetWorkWithAllConnectionsFromOnePoint()
        {
            Connectivity c = new Connectivity(5);
            c.AddConnection(1, 2);
            c.AddConnection(1, 3);
            c.AddConnection(1, 4);
            c.AddConnection(1, 5);
            Assert.Equal(4, c.Calculate(1));
        }
    }
}
