namespace ProgramTests
{
    using System;
    using System.IO;
    using Xunit;
    using Exercise004;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("5-4.1")]
        public void TestExample()
        {
            Labyrinth l = new Labyrinth();
            char[,] c =
            { {'#','#','#','#','#','#','#'},
            {'#','x','#','.','y','.','#'},
            {'#','.','#','.','#','.','#'},
            {'#','.','.','.','.','.','#'},
            {'#','#','#','#','#','#','#'} };
            Assert.Equal("DDRRUUR", l.Search(c));
        }

        [Fact]
        [Points("5-4.1")]
        public void TestSimilarSizeWithNoRoute()
        {
            Labyrinth l = new Labyrinth();
            char[,] c =
            { {'#','#','#','#','#','#','#'},
            {'#','x','#','.','#','y','#'},
            {'#','.','#','.','#','.','#'},
            {'#','.','#','.','#','.','#'},
            {'#','#','#','#','#','#','#'} };
            Assert.Equal("", l.Search(c));
        }

        [Fact]
        [Points("5-4.1")]
        public void TestExampleMovedX()
        {
            Labyrinth l = new Labyrinth();
            char[,] c =
            { {'#','#','#','#','#','#','#'},
            {'#','.','#','.','y','.','#'},
            {'#','.','#','.','#','.','#'},
            {'#','x','.','.','.','.','#'},
            {'#','#','#','#','#','#','#'} };
            Assert.Equal("RRUUR", l.Search(c));
        }

        [Fact]
        [Points("5-4.2")]
        public void TestSmallerWithNoRoute()
        {
            Labyrinth l = new Labyrinth();
            char[,] c =
            { {'#','#','#','#','#','#'},
            {'#','x','#','.','y','#'},
            {'#','#','#','#','#','#'} };
            Assert.Equal("", l.Search(c));
        }

        [Fact]
        [Points("5-4.2")]
        public void TestTinyWithOneR()
        {
            Labyrinth l = new Labyrinth();
            char[,] c =
            { {'#','#','#','#'},
            {'#','x','y','#'},
            {'#','#','#','#'}};
            Assert.Equal("R", l.Search(c));
        }

        [Fact]
        [Points("5-4.2")]
        public void TestTinyWithOneL()
        {
            Labyrinth l = new Labyrinth();
            char[,] c =
            { {'#','#','#','#'},
            {'#','y','x','#'},
            {'#','#','#','#'}};
            Assert.Equal("L", l.Search(c));
        }

        [Fact]
        [Points("5-4.3")]
        public void TestTinyWithNoRoute()
        {
            Labyrinth l = new Labyrinth();
            char[,] c =
            { {'#','#','#','#','#'},
            {'#','x','#','y','#'},
            {'#','#','#','#','#'}};
            Assert.Equal("", l.Search(c));
        }

        [Fact]
        [Points("5-4.3")]
        public void TestMoreComplexRoute()
        {
            Labyrinth l = new Labyrinth();
            char[,] c =
            { {'#','#','#','#','#','#','#'},
            {'#','x','#','.','.','.','#'},
            {'#','.','#','.','#','.','#'},
            {'#','.','#','.','#','.','#'},
            {'#','.','#','.','#','.','#'},
            {'#','.','.','.','#','y','#'},
            {'#','#','#','#','#','#','#'} };
            Assert.Equal("DDDDRRUUUURRDDDD", l.Search(c));
        }

        [Fact]
        [Points("5-4.3")]
        public void TestMoreComplexRouteFlipped()
        {
            Labyrinth l = new Labyrinth();
            char[,] c =
            { {'#','#','#','#','#','#','#'},
            {'#','y','#','.','.','.','#'},
            {'#','.','#','.','#','.','#'},
            {'#','.','#','.','#','.','#'},
            {'#','.','#','.','#','.','#'},
            {'#','.','.','.','#','x','#'},
            {'#','#','#','#','#','#','#'} };
            Assert.Equal("UUUULLDDDDLLUUUU", l.Search(c));
        }

        [Fact]
        [Points("5-4.4")]
        public void TestLargerLabyrinth()
        {
            Labyrinth l = new Labyrinth();
            char[,] c =
            { {'#','#','#','#','#','#','#','#'},
            {'#','x','#','.','.','.',',','#'},
            {'#','.','#','.','#','#','.','#'},
            {'#','.','#','.','.','#','.','#'},
            {'#','.','#','#','.','#','.','#'},
            {'#','.','#','.','.','#','.','#'},
            {'#','.','#','.','#','#','.','#'},
            {'#','.','#','.','.','#','.','#'},
            {'#','.','#','#','.','#','y','#'},
            {'#','.','.','.','.','#','.','#'},
            {'#','#','#','#','#','#','#','#'} };
            Assert.Equal("DDDDDDDDRRRUULUURUULUURRRDDDDDDD", l.Search(c));
        }

        [Fact]
        [Points("5-4.4")]
        public void TestLargerLabyrinthNoRoute()
        {
            Labyrinth l = new Labyrinth();
            char[,] c =
            { {'#','#','#','#','#','#','#','#'},
            {'#','x','#','.','.','.',',','#'},
            {'#','.','#','.','#','#','.','#'},
            {'#','.','#','.','.','#','.','#'},
            {'#','.','#','#','.','#','.','#'},
            {'#','.','#','.','.','#','.','#'},
            {'#','.','#','.','#','#','.','#'},
            {'#','.','#','.','.','#','.','#'},
            {'#','.','#','#','.','#','#','#'},
            {'#','.','.','.','.','#','y','#'},
            {'#','#','#','#','#','#','#','#'} };
            Assert.Equal("", l.Search(c));
        }

        [Fact]
        [Points("5-4.4")]
        public void TestLargerLabyrinthDifferentPositions()
        {
            Labyrinth l = new Labyrinth();
            char[,] c =
            { {'#','#','#','#','#','#','#','#'},
            {'#','.','#','.','.','.',',','#'},
            {'#','.','#','.','#','#','.','#'},
            {'#','.','#','.','x','#','.','#'},
            {'#','.','#','#','.','#','.','#'},
            {'#','.','#','.','.','#','.','#'},
            {'#','y','#','.','#','#','.','#'},
            {'#','.','#','.','.','#','.','#'},
            {'#','.','#','#','.','#','.','#'},
            {'#','.','.','.','.','#','.','#'},
            {'#','#','#','#','#','#','#','#'} };
            Assert.Equal("DDLDDRDDLLLUUU", l.Search(c));
        }
    }
}
