namespace ProgramTests
{
    using Xunit;
    using Exercise002;
    using TestMyCode.CSharp.API.Attributes;

    public partial class ProgramTest
    {
        [Fact]
        [Points("5-2.1")]
        public void TestExample()
        {
            Components k = new Components(6);
            k.AddConnection(1, 2);
            k.AddConnection(2, 3);
            k.AddConnection(1, 3);
            k.AddConnection(3, 4);
            k.AddConnection(5, 6);
            Assert.Equal(2, k.Calculate());
        }

        [Fact]
        [Points("5-2.2")]
        public void TestLargerNetWorkWithMultipleConnectedGraphs()
        {
            Components k = new Components(22);
            k.AddConnection(1, 2);
            k.AddConnection(2, 3);
            k.AddConnection(1, 3);
            k.AddConnection(3, 4);
            k.AddConnection(5, 6);
            k.AddConnection(7, 6);
            k.AddConnection(8, 9);
            k.AddConnection(9, 10);
            k.AddConnection(11, 12);
            k.AddConnection(11, 13);
            k.AddConnection(11, 14);
            k.AddConnection(14, 15);
            k.AddConnection(16, 17);
            k.AddConnection(16, 18);
            k.AddConnection(17, 18);
            k.AddConnection(19, 20);
            k.AddConnection(20, 21);
            k.AddConnection(21, 22);
            Assert.Equal(6, k.Calculate());
        }

        [Fact]
        [Points("5-2.1")]
        public void TestSmallerNetworkWithSingleConnected()
        {
            Components k = new Components(7);
            k.AddConnection(1, 2);
            k.AddConnection(2, 3);
            k.AddConnection(1, 5);
            k.AddConnection(3, 4);
            k.AddConnection(5, 6);
            k.AddConnection(7, 6);
            Assert.Equal(1, k.Calculate());
        }

        [Fact]
        [Points("5-2.2")]
        public void TestLargeNetworkWithSingleConnected()
        {
            Components k = new Components(22);
            k.AddConnection(1, 2);
            k.AddConnection(2, 3);
            k.AddConnection(1, 5);
            k.AddConnection(3, 4);
            k.AddConnection(5, 6);
            k.AddConnection(7, 6);
            k.AddConnection(5, 8);
            k.AddConnection(8, 9);
            k.AddConnection(9, 10);
            k.AddConnection(1, 12);
            k.AddConnection(11, 12);
            k.AddConnection(11, 13);
            k.AddConnection(11, 14);
            k.AddConnection(14, 15);
            k.AddConnection(15, 21);
            k.AddConnection(16, 17);
            k.AddConnection(16, 18);
            k.AddConnection(17, 18);
            k.AddConnection(15, 16);
            k.AddConnection(19, 20);
            k.AddConnection(20, 21);
            k.AddConnection(21, 22);
            Assert.Equal(1, k.Calculate());
        }

        [Fact]
        [Points("5-2.2")]
        public void TestSmallNetworkWithNoConnectionsToEachOther()
        {
            Components k = new Components(8);
            Assert.Equal(8, k.Calculate());
        }

        [Fact]
        [Points("5-2.1")]
        public void TestSingleNodeNetwork()
        {
            Components k = new Components(1);
            Assert.Equal(1, k.Calculate());
        }

        [Fact]
        [Points("5-2.2")]
        public void TestLargeNetWork()
        {
            Components k = new Components(42);
            k.AddConnection(1, 2);
            k.AddConnection(2, 3);
            k.AddConnection(1, 3);
            k.AddConnection(3, 4);
            k.AddConnection(5, 6);
            k.AddConnection(7, 6);
            k.AddConnection(8, 9);
            k.AddConnection(9, 10);
            k.AddConnection(11, 12);
            k.AddConnection(11, 13);
            k.AddConnection(11, 14);
            k.AddConnection(14, 15);
            k.AddConnection(16, 17);
            k.AddConnection(16, 18);
            k.AddConnection(17, 18);
            k.AddConnection(19, 20);
            k.AddConnection(20, 21);
            k.AddConnection(21, 22);
            Assert.Equal(26, k.Calculate());
        }

        [Fact]
        [Points("5-2.1")]
        public void TestSmallNetwork()
        {
            Components k = new Components(4);
            k.AddConnection(1, 2);
            k.AddConnection(2, 3);
            k.AddConnection(1, 3);
            Assert.Equal(2, k.Calculate());
        }
    }
}
