namespace ProgramTests
{
    using Xunit;
    using Exercise003;
    using TestMyCode.CSharp.API.Attributes;

    public partial class ProgramTest
    {
        [Fact]
        [Points("5-3.1")]
        public void TestExample()
        {
            Communication comms = new Communication(6);
            comms.AddConnection(1, 2);
            comms.AddConnection(2, 3);
            comms.AddConnection(1, 3);
            comms.AddConnection(3, 4);
            comms.AddConnection(5, 6);
            Assert.True(comms.Examine(1, 4));
            Assert.False(comms.Examine(2, 5));
            Assert.True(comms.Examine(5, 6));
        }

        [Fact]
        [Points("5-3.1")]
        public void TestSmallNetwork()
        {
            Communication comms = new Communication(8);
            comms.AddConnection(1, 2);
            comms.AddConnection(2, 3);
            comms.AddConnection(1, 3);
            comms.AddConnection(3, 4);
            comms.AddConnection(5, 6);
            comms.AddConnection(4, 8);
            Assert.True(comms.Examine(1, 8));
            Assert.False(comms.Examine(1, 7));
        }

        [Fact]
        [Points("5-3.1")]
        public void TestSmallNetworkWithEverythingConnected()
        {
            Communication comms = new Communication(6);
            comms.AddConnection(1, 2);
            comms.AddConnection(2, 3);
            comms.AddConnection(2, 5);
            comms.AddConnection(3, 4);
            comms.AddConnection(5, 6);
            Assert.True(comms.Examine(1, 4));
            Assert.True(comms.Examine(1, 2));
            Assert.True(comms.Examine(1, 3));
            Assert.True(comms.Examine(1, 4));
            Assert.True(comms.Examine(1, 5));
            Assert.True(comms.Examine(1, 6));
            Assert.True(comms.Examine(2, 5));
            Assert.True(comms.Examine(5, 6));
        }

        [Fact]
        [Points("5-3.1")]
        public void TestSmallNetworkNoConnections()
        {
            Communication comms = new Communication(3);
            Assert.False(comms.Examine(1, 3));
            Assert.False(comms.Examine(2, 1));
            Assert.False(comms.Examine(3, 2));
        }

        [Fact]
        [Points("5-3.2")]
        public void TestLargerNetwork()
        {
            Communication comms = new Communication(16);
            comms.AddConnection(1, 2);
            comms.AddConnection(2, 3);
            comms.AddConnection(1, 3);
            comms.AddConnection(3, 4);
            comms.AddConnection(5, 6);
            comms.AddConnection(5, 16);
            comms.AddConnection(15, 16);
            comms.AddConnection(15, 6);
            comms.AddConnection(12, 14);
            Assert.True(comms.Examine(5, 16));
            Assert.False(comms.Examine(12, 55));
            Assert.True(comms.Examine(4, 1));
        }

        [Fact]
        [Points("5-3.2")]
        public void TestLargerNetworkNoConnections()
        {
            Communication comms = new Communication(42);
            Assert.False(comms.Examine(1, 3));
            Assert.False(comms.Examine(2, 1));
            Assert.False(comms.Examine(3, 2));
            Assert.False(comms.Examine(3, 42));
            Assert.False(comms.Examine(42, 41));
            Assert.False(comms.Examine(30, 39));
            Assert.False(comms.Examine(33, 30));
            Assert.False(comms.Examine(3, 4));
            Assert.False(comms.Examine(42, 1));
        }

        [Fact]
        [Points("5-3.2")]
        public void TestSingleNetwork()
        {
            Communication comms = new Communication(1);
            Assert.True(comms.Examine(1, 1));
        }

        [Fact]
        [Points("5-3.2")]
        public void TestNetworkWithConnections()
        {
            Communication comms = new Communication(6);
            comms.AddConnection(1, 2);
            comms.AddConnection(2, 3);
            comms.AddConnection(1, 3);
            comms.AddConnection(3, 4);
            comms.AddConnection(5, 6);
            Assert.True(comms.Examine(1, 3));
            Assert.False(comms.Examine(4, 5));
            Assert.True(comms.Examine(6, 5));
        }
    }
}
