namespace ProgramTests
{
    using System;
    using System.IO;
    using Xunit;
    using Exercise002;
    using TestMyCode.CSharp.API.Attributes;

    public partial class ProgramTest
    {
        [Fact]
        [Points("4-2.1")]
        public void TestOneTwoThree()
        {
            CircleGame g = new CircleGame();
            Assert.Equal(119, g.Last(123));
        }

        [Fact]
        [Points("4-2.2")]
        public void TestMillion()
        {
            CircleGame g = new CircleGame();
            Assert.Equal(951425, g.Last(1000000));
        }

        [Fact]
        [Points("4-2.1")]
        public void TestOnes()
        {
            CircleGame g = new CircleGame();
            Assert.Equal(1, g.Last(1));
            Assert.Equal(1, g.Last(2));
            Assert.Equal(1, g.Last(4));
            Assert.Equal(1, g.Last(16));
        }

        [Fact]
        [Points("4-2.1")]
        public void TestRandom()
        {
            int n = 2;
            for (int i = 0; i < 12; i++)
            {
                n *= 2;
            }
            CircleGame g = new CircleGame();
            Assert.Equal(1, g.Last(n));
        }

        [Fact]
        [Points("4-2.2")]
        public void TestAnswerToLife()
        {
            CircleGame g = new CircleGame();
            Assert.Equal(21, g.Last(42));
        }

        [Fact]
        [Points("4-2.2")]
        public void TestOriginal()
        {
            CircleGame g = new CircleGame();
            Assert.Equal(19, g.Last(41));
        }

        [Fact]
        [Points("4-2.1")]
        public void TestHundredThau()
        {
            CircleGame g = new CircleGame();
            Assert.Equal(68929, g.Last(100000));
        }

        [Fact]
        [Points("4-2.2")]
        public void TestBigNumber()
        {
            CircleGame g = new CircleGame();
            Assert.Equal(18583, g.Last(25675));
        }
    }
}
