namespace ProgramTests
{
    using System;
    using System.IO;
    using Xunit;
    using Exercise003;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("4-3.1")]
        public void TestTwoItemsAdded()
        {
            SmallestDistance s = new SmallestDistance();
            s.Add(3);
            s.Add(8);
            Assert.Equal(5, s.Calculate());
        }

        [Fact]
        [Points("4-3.1")]
        public void TestExample()
        {
            SmallestDistance s = new SmallestDistance();
            s.Add(3);
            s.Add(8);
            Assert.Equal(5, s.Calculate());
            s.Add(20);
            Assert.Equal(5, s.Calculate());
            s.Add(9);
            Assert.Equal(1, s.Calculate());
            s.Add(20);
            Assert.Equal(0, s.Calculate());
        }

        [Fact]
        [Points("4-3.1")]
        public void TestReversedList()
        {
            SmallestDistance s = new SmallestDistance();
            for (int i = 10; i > 0; i--)
            {
                s.Add(i);
            }
            Assert.Equal(1, s.Calculate());

        }


        [Fact]
        [Points("4-3.1")]
        public void TestOrderedListWithHops()
        {
            SmallestDistance s = new SmallestDistance();
            Random r = new Random();
            int m = r.Next(2, 12);
            for (int i = 10; i > 0; i--)
            {
                s.Add(i * m);
            }
            Assert.Equal(m, s.Calculate());

        }

        [Fact]
        [Points("4-3.2")]
        public void TestOrderedList()
        {
            SmallestDistance s = new SmallestDistance();
            for (int i = 10; i > 0; i--)
            {
                s.Add(i);
            }
            Assert.Equal(1, s.Calculate());
        }

        [Fact]
        [Points("4-3.2")]
        public void TestBigItems()
        {
            SmallestDistance s = new SmallestDistance();
            s.Add(1345);
            s.Add(23);
            s.Add(345);
            s.Add(56);
            s.Add(978);
            s.Add(654);
            s.Add(677);
            s.Add(6234);
            s.Add(1134);
            Assert.Equal(23, s.Calculate());
        }

        [Fact]
        [Points("4-3.2")]
        public void TestBigDifferences()
        {
            SmallestDistance s = new SmallestDistance();
            s.Add(100000);
            s.Add(100);
            s.Add(5001);
            s.Add(39560);
            s.Add(549786);
            s.Add(357951);
            s.Add(999999);
            s.Add(1134);
            Assert.Equal(1034, s.Calculate());
        }

        [Fact]
        [Points("4-3.2")]
        public void TestAllSame()
        {
            SmallestDistance s = new SmallestDistance();
            for (int i = 10; i > 0; i--)
            {
                s.Add(10);
            }
            Assert.Equal(0, s.Calculate());
        }
    }
}
