namespace ProgramTests
{
    using System;
    using System.IO;
    using Xunit;
    using Exercise005;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("4-5.1")]
        public void TestExampleFirstPart()
        {
            BinarySearchTree bs = new BinarySearchTree();
            bs.Add(5);
            bs.Add(4);
            bs.Add(6);
            Assert.Equal(1, bs.Height());
        }

        [Fact]
        [Points("4-5.1")]
        public void TestWholeExample()
        {
            BinarySearchTree bs = new BinarySearchTree();
            bs.Add(5);
            bs.Add(4);
            bs.Add(6);
            bs.Add(3);
            bs.Add(1);
            bs.Add(7);
            Assert.Equal(3, bs.Height());
        }

        [Fact]
        [Points("4-5.1")]
        public void TestLargerValues()
        {
            BinarySearchTree bs = new BinarySearchTree();
            bs.Add(234);
            bs.Add(232);
            bs.Add(5352);
            bs.Add(12345);
            bs.Add(9876);
            bs.Add(123);
            bs.Add(7856);
            bs.Add(782346);
            bs.Add(7851);
            bs.Add(78526);
            bs.Add(783456);
            bs.Add(784236);
            bs.Add(78256);
            Assert.Equal(5, bs.Height());
        }

        [Fact]
        [Points("4-5.1")]
        public void TestOrderedTree()
        {
            BinarySearchTree bs = new BinarySearchTree();
            bs.Add(234);
            bs.Add(235);
            bs.Add(237);
            bs.Add(240);
            bs.Add(242);
            bs.Add(255);
            bs.Add(300);
            bs.Add(356);
            bs.Add(366);
            bs.Add(367);
            bs.Add(1243);
            bs.Add(1389);
            bs.Add(20001);
            Assert.Equal(12, bs.Height());
        }

        [Fact]
        [Points("4-5.2")]
        public void TestVShape()
        {
            BinarySearchTree bs = new BinarySearchTree();
            bs.Add(300);
            bs.Add(356);
            bs.Add(366);
            bs.Add(367);
            bs.Add(1243);
            bs.Add(1389);
            bs.Add(20001);
            bs.Add(234);
            bs.Add(235);
            bs.Add(237);
            bs.Add(240);
            bs.Add(242);
            bs.Add(255);
            Assert.Equal(6, bs.Height());
        }

        [Fact]
        [Points("4-5.2")]
        public void TestEvenDistribution()
        {
            BinarySearchTree bs = new BinarySearchTree();
            bs.Add(8);
            bs.Add(7);
            bs.Add(4);
            bs.Add(5);
            bs.Add(3);
            bs.Add(12);
            bs.Add(10);
            bs.Add(11);
            bs.Add(9);
            Assert.Equal(3, bs.Height());
        }

        [Fact]
        [Points("4-5.2")]
        public void TestRoot()
        {
            BinarySearchTree bs = new BinarySearchTree();
            bs.Add(8);
            Assert.Equal(0, bs.Height());
        }

        [Fact]
        [Points("4-5.2")]
        public void TestDifferentFullTree()
        {
            BinarySearchTree bs = new BinarySearchTree();
            bs.Add(8);
            bs.Add(5);
            bs.Add(10);
            bs.Add(3);
            bs.Add(6);
            bs.Add(1);
            bs.Add(4);
            bs.Add(14);
            bs.Add(13);
            bs.Add(15);
            Assert.Equal(3, bs.Height());
        }
    }
}
