namespace ProgramTests
{
    using System;
    using System.IO;
    using Xunit;
    using Exercise004;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("4-4.1")]
        public void TestSmallerExample()
        {
            Order o = new Order();
            int[] a2 = { 4, 2, 1, 3, 5 };
            int[] b2 = { 2, 4, 3, 1, 5 };
            int[] c2 = o.Create(a2, b2);
            Assert.Equal("2 3 5 1 4", String.Join(" ", c2));
        }

        [Fact]
        [Points("4-4.1")]
        public void TestSmallArray()
        {
            Order o = new Order();
            int[] a2 = { 1, 2, 4, 5, 3, 6 };
            int[] b2 = { 4, 2, 5, 1, 3, 6 };
            int[] c2 = o.Create(a2, b2);
            Assert.Equal("4 5 2 6 3 1", String.Join(" ", c2));
        }

        [Fact]
        [Points("4-4.1")]
        public void TestTwoNodes()
        {
            Order o = new Order();
            int[] a2 = { 1, 2 };
            int[] b2 = { 2, 1 };
            int[] c2 = o.Create(a2, b2);
            Assert.Equal("2 1", String.Join(" ", c2));
        }

        [Fact]
        [Points("4-4.1")]
        public void TestThreeNodes()
        {
            Order o = new Order();
            int[] a2 = { 1, 2, 3 };
            int[] b2 = { 3, 2, 1 };
            int[] c2 = o.Create(a2, b2);
            Assert.Equal("3 2 1", String.Join(" ", c2));
        }

        [Fact]
        [Points("4-4.2")]
        public void TestLargerExample()
        {
            Order o = new Order();
            int[] a1 = { 1, 2, 4, 3, 5, 6, 7, 8 };
            int[] b1 = { 4, 2, 1, 5, 3, 7, 6, 8 };
            int[] c1 = o.Create(a1, b1);
            Assert.Equal("4 2 5 7 8 6 3 1", String.Join(" ", c1));
        }


        [Fact]
        [Points("4-4.2")]
        public void TestDifferentTree()
        {
            Order o = new Order();
            int[] a2 = { 1, 2, 4, 3, 5, 7, 8, 6 };
            int[] b2 = { 4, 2, 1, 7, 5, 8, 3, 6 };
            int[] c2 = o.Create(a2, b2);
            Assert.Equal("4 2 7 8 5 6 3 1", String.Join(" ", c2));
        }

        [Fact]
        [Points("4-4.2")]
        public void TestOrderedPreOrder()
        {
            Order o = new Order();
            int[] a1 = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };
            int[] b1 = { 3, 2, 5, 4, 1, 8, 7, 6, 9 };
            int[] c2 = o.Create(a1, b1);
            Assert.Equal("3 5 4 2 8 7 9 6 1", String.Join(" ", c2));
        }

        [Fact]
        [Points("4-4.2")]
        public void TestThreeNodesDifferentOrder()
        {
            Order o = new Order();
            int[] a2 = { 3, 1, 2 };
            int[] b2 = { 1, 3, 2 };
            int[] c2 = o.Create(a2, b2);
            Assert.Equal("1 2 3", String.Join(" ", c2));
        }
    }

}
