namespace ProgramTests
{
    using System;
    using System.IO;
    using Xunit;
    using Exercise001;
    using TestMyCode.CSharp.API.Attributes;
    public partial class ProgramTest
    {
        [Fact]
        [Points("4-1.1")]
        public void TestLinkedListCreation()
        {
            LinkedList list = new LinkedList();
            Assert.Equal(typeof(LinkedList), list.GetType());
        }

        [Fact]
        [Points("4-1.1")]
        public void TestAddFirst()
        {
            LinkedList list = new LinkedList();
            list.AddFirst(2);
            list.AddFirst(7);
            list.AddFirst(6);
            list.AddFirst(4);
            Assert.Equal(4, list.GetNode(0));
            Assert.Equal(2, list.GetNode(3));
        }

        [Fact]
        [Points("4-1.1")]
        public void TestAddLast()
        {
            LinkedList list = new LinkedList();
            list.AddLast(2);
            list.AddLast(3);
            list.AddLast(2);
            list.AddLast(4);
            Assert.Equal(2, list.GetNode(0));
            Assert.Equal(4, list.GetNode(3));
        }

        [Fact]
        [Points("4-1.1")]
        public void TestNodeCreation()
        {
            Node nod = new Node(1, null, null);
            Assert.Equal(typeof(Node), nod.GetType());
            Assert.Null(nod.previous);
            Assert.Null(nod.next);
            Assert.Equal(1, nod.value);
        }



        [Fact]
        [Points("4-1.2")]
        public void TestToString()
        {
            LinkedList myLinks = new LinkedList();
            myLinks.AddLast(12);
            myLinks.AddFirst(21);
            myLinks.AddLast(34);
            myLinks.AddLast(18);
            myLinks.AddFirst(69);
            // Assert
            Assert.Equal("69 21 12 34 18", myLinks.ToString().Replace("\r\n", "\n"));

        }

        [Fact]
        [Points("4-1.2")]
        public void TestRemoveFirst()
        {
            LinkedList list = new LinkedList();
            list.AddFirst(23);
            list.AddFirst(72);
            list.AddFirst(46);
            list.AddFirst(44);
            Assert.Equal(44, list.GetNode(0));
            list.RemoveFirst();
            Assert.Equal(46, list.GetNode(0));
            Assert.Throws<NullReferenceException>(() => list.GetNode(3));

        }

        [Fact]
        [Points("4-1.2")]
        public void TestRemoveLast()
        {
            LinkedList list = new LinkedList();
            list.AddFirst(232);
            list.AddFirst(721);
            list.AddFirst(416);
            list.AddFirst(424);
            Assert.Equal(232, list.GetNode(3));
            Assert.Equal(721, list.GetNode(2));
            list.RemoveLast();
            Assert.Equal(721, list.GetNode(2));
            Assert.Throws<NullReferenceException>(() => list.GetNode(3));
        }

        [Fact]
        [Points("4-1.2")]
        public void TestExample()
        {
            using (StringWriter sw = new StringWriter())
            {
                sw.NewLine = "\n";
                // Save a reference to the standard output.
                TextWriter stdout = Console.Out;

                // Redirect standard output to variable.
                Console.SetOut(sw);
                LinkedList myLinks = new LinkedList();
                myLinks.AddLast(1);
                myLinks.AddFirst(2);
                myLinks.AddLast(3);
                myLinks.AddLast(12);
                myLinks.AddFirst(6);
                Console.WriteLine(myLinks); // 6 2 1 3 12
                Console.WriteLine(myLinks.GetNode(4)); // 12
                myLinks.RemoveFirst();
                Console.WriteLine(myLinks); // 2 1 3 12
                myLinks.RemoveFirst();
                Console.WriteLine(myLinks); // 1 3 12
                myLinks.RemoveLast();
                Console.WriteLine(myLinks.GetNode(0)); // 1
                Console.WriteLine(myLinks.GetNode(1)); // 3
                Console.WriteLine(myLinks); // 1 3
                Console.SetOut(stdout);

                // Assert
                Assert.Equal(@"6 2 1 3 12
12
2 1 3 12
1 3 12
1
3
1 3
", sw.ToString());
            }
        }

    }
}
