namespace ProgramTests
{
    using System;
    using System.IO;
    using Xunit;
    using Exercise013;
    using TestMyCode.CSharp.API.Attributes;


    [Points("1-13")]
    public partial class ProgramTest
    {
        [Fact]
        public void TestDoublePrint()
        {
            using (StringWriter sw = new StringWriter())
            {
                // Save a reference to the standard output.
                TextWriter stdout = Console.Out;

                // Redirect standard output to variable.
                Console.SetOut(sw);

                var data = String.Join(Environment.NewLine, new[]
                {
                Convert.ToDouble("12.4", System.Globalization.CultureInfo.InvariantCulture).ToString()
                });

                Console.SetIn(new System.IO.StringReader(data));

                // Call student's code
                Program.Main(null!);

                // Restore the original standard output.
                Console.SetOut(stdout);

                // Assert
                Assert.Contains("Give a number!\nYou gave " + (12.4).ToString().Replace(",", ".") + "\n", sw.ToString().Replace("\r\n", "\n").Replace(",", "."));
            }
        }

        [Fact]
        public void TestDoublePrintSecond()
        {
            using (StringWriter sw = new StringWriter())
            {
                // Save a reference to the standard output.
                TextWriter stdout = Console.Out;

                // Redirect standard output to variable.
                Console.SetOut(sw);

                var data = String.Join(Environment.NewLine, new[]
                {
                Convert.ToDouble("3.4", System.Globalization.CultureInfo.InvariantCulture).ToString()
                });

                Console.SetIn(new System.IO.StringReader(data));

                // Call student's code
                Program.Main(null!);

                // Restore the original standard output.
                Console.SetOut(stdout);

                // Assert
                Assert.Contains("Give a number!\nYou gave " + (3.4).ToString().Replace(",", ".") + "\n", sw.ToString().Replace("\r\n", "\n").Replace(",", "."));
            }
        }

        [Fact]
        public void TestDoublePrintAnother()
        {
            using (StringWriter sw = new StringWriter())
            {
                // Save a reference to the standard output.
                TextWriter stdout = Console.Out;

                // Redirect standard output to variable.
                Console.SetOut(sw);

                var data = String.Join(Environment.NewLine, new[]
                {
                Convert.ToDouble("4.19", System.Globalization.CultureInfo.InvariantCulture).ToString()
                });

                Console.SetIn(new System.IO.StringReader(data));

                // Call student's code
                Program.Main(null!);

                // Restore the original standard output.
                Console.SetOut(stdout);

                // Assert
                Assert.Contains("Give a number!\nYou gave " + (4.19).ToString().Replace(",", ".") + "\n", sw.ToString().Replace("\r\n", "\n").Replace(",", "."));
            }
        }

        [Fact]
        public void CheckNumberHasBeenConverted()
        {
            int counter = 0;
            Mono.Cecil.AssemblyDefinition assembly = Mono.Cecil.AssemblyDefinition.ReadAssembly(typeof(Program).Module.FullyQualifiedName);
            Mono.Cecil.TypeDefinition type = assembly.MainModule.GetType(typeof(Program).FullName);
            Mono.Cecil.MethodDefinition method = null;
            foreach (Mono.Cecil.MethodDefinition iter in type.Methods)
            {
                if (iter.Name == "Main")
                {
                    method = iter;
                }
            }
            foreach (Mono.Cecil.Cil.Instruction instruction in method.Body.Instructions)
            {
                if (instruction.OpCode != Mono.Cecil.Cil.OpCodes.Call)
                {
                    continue;
                }

                if (instruction.Operand is not Mono.Cecil.MethodReference methodReference)
                {
                    continue;
                }
                if (methodReference.FullName == "System.Double System.Convert::ToDouble(System.String)" || methodReference.FullName == "System.Double System.Double::Parse(System.String)")
                {
                    counter++;
                }
            }
            Assert.Equal(1, counter);
        }
    }
}
