library("testthat")

points_for_all_tests(character(0))

set.seed(42); someX <- matrix(rnorm(3*4), nrow=3, ncol=4)
test("squareSums returns a list with correct names", character(0), {
  expect_true(is.list(squareSums(someX)))
  expect_equal(names(squareSums(someX)), c("ssr", "ssc", "sse"))
})

test("squareSums returns correct ssr", character(0), {
  expect_equal(squareSums(someX)$ssr, 1.611729, tolerance=1e-6, scale=1)
})

test("squareSums returns correct ssc", character(0), {
  expect_equal(squareSums(someX)$ssc, 1.982221, tolerance=1e-6, scale=1)
})

test("squareSums returns correct sse", character(0), {
  expect_equal(squareSums(someX)$sse, 5.767522, tolerance=1e-6, scale=1)
})
